/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheDestroyCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

abstract class AbstractClientCacheProxyBase<K, V>
implements ICacheInternal<K, V> {
    static final int TIMEOUT = 10;
    protected final ClientContext clientContext;
    protected final CacheConfig<K, V> cacheConfig;
    protected final String name;
    protected final String nameWithPrefix;
    private final CopyOnWriteArrayList<Future> loadAllTasks = new CopyOnWriteArrayList();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicInteger completionIdCounter = new AtomicInteger();

    protected AbstractClientCacheProxyBase(CacheConfig cacheConfig, ClientContext clientContext) {
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.clientContext = clientContext;
    }

    protected int nextCompletionId() {
        return this.completionIdCounter.incrementAndGet();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        for (Future f : this.loadAllTasks) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.loadAllTasks.clear();
        this.closeListeners();
    }

    public void destroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return;
        }
        this.isClosed.set(true);
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(this.nameWithPrefix);
            ClientMessage request = CacheDestroyCodec.encodeRequest((String)this.nameWithPrefix);
            ClientInvocation clientInvocation = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), request, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        if (!this.isClosed.compareAndSet(true, false)) {
            return;
        }
    }

    protected abstract void closeListeners();

    public String getNameWithPrefix() {
        return this.nameWithPrefix;
    }

    protected <T> T toObject(Object data) {
        return (T)this.clientContext.getSerializationService().toObject(data);
    }

    protected Data toData(Object o) {
        return this.clientContext.getSerializationService().toData(o);
    }

    protected ClientMessage invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), clientMessage).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected ClientMessage invoke(ClientMessage clientMessage, Data keyData) {
        try {
            int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
            ClientInvocationFuture future = new ClientInvocation((HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance(), clientMessage, partitionId).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void submitLoadAllTask(ClientMessage request, CompletionListener completionListener, final Set<Data> keys) {
        final long start = System.nanoTime();
        LoadAllTask loadAllTask = new LoadAllTask(request, completionListener);
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.clientContext.getExecutionService();
        final ICompletableFuture future = executionService.submitInternal(loadAllTask);
        this.loadAllTasks.add((Future)future);
        future.andThen(new ExecutionCallback(){

            public void onResponse(Object response) {
                AbstractClientCacheProxyBase.this.loadAllTasks.remove(future);
                AbstractClientCacheProxyBase.this.onLoadAll(keys, response, start, System.nanoTime());
            }

            public void onFailure(Throwable t) {
                AbstractClientCacheProxyBase.this.loadAllTasks.remove(future);
            }
        });
    }

    protected void onLoadAll(Set<Data> keys, Object response, long start, long end) {
    }

    private final class LoadAllTask
    implements Runnable {
        private final ClientMessage request;
        private final CompletionListener completionListener;

        private LoadAllTask(ClientMessage request, CompletionListener completionListener) {
            this.request = request;
            this.completionListener = completionListener;
        }

        @Override
        public void run() {
            block3: {
                try {
                    AbstractClientCacheProxyBase.this.invoke(this.request);
                    if (this.completionListener != null) {
                        this.completionListener.onCompletion();
                    }
                }
                catch (Exception e) {
                    if (this.completionListener == null) break block3;
                    this.completionListener.onException(e);
                }
            }
        }
    }
}

