/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientDelegatingFuture<V>
implements ICompletableFuture<V> {
    private final ClientInvocationFuture future;
    private final SerializationService serializationService;
    private final ClientMessageDecoder clientMessageDecoder;
    private final V defaultValue;
    private final Object mutex = new Object();
    private Throwable error;
    private V deserializedValue;
    private Object response;
    private volatile boolean done;

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, V defaultValue) {
        this.future = clientInvocationFuture;
        this.serializationService = serializationService;
        this.clientMessageDecoder = clientMessageDecoder;
        this.defaultValue = defaultValue;
    }

    public ClientDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder) {
        this.future = clientInvocationFuture;
        this.serializationService = serializationService;
        this.clientMessageDecoder = clientMessageDecoder;
        this.defaultValue = null;
    }

    public <R> void andThenInternal(ExecutionCallback<R> callback) {
        this.future.andThenInternal(new DelegatingExecutionCallback<R>(callback, false));
    }

    public void andThen(ExecutionCallback<V> callback) {
        this.future.andThen(new DelegatingExecutionCallback<V>(callback, true));
    }

    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        this.future.andThen(new DelegatingExecutionCallback<V>(callback, true), executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.done = true;
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public final boolean isDone() {
        return this.done ? this.done : this.future.isDone();
    }

    public Object getResponse() {
        return this.response;
    }

    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return (V)ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.done) {
                    try {
                        this.response = this.resolveMessageToValue(this.future.get(timeout, unit));
                        if (this.deserializedValue == null) {
                            this.deserializedValue = this.serializationService.toObject(this.response);
                        }
                    }
                    catch (InterruptedException e) {
                        this.error = e;
                    }
                    catch (ExecutionException e) {
                        this.error = e;
                    }
                    this.done = true;
                }
            }
        }
        if (this.error != null) {
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof CancellationException) {
                throw (CancellationException)this.error;
            }
            if (this.error instanceof InterruptedException) {
                throw (InterruptedException)this.error;
            }
            throw new ExecutionException(this.error);
        }
        return this.getResult();
    }

    private V getResult() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.deserializedValue != null) {
            return this.deserializedValue;
        }
        if (this.response != null) {
            this.deserializedValue = this.serializationService.toObject(this.response);
        }
        return this.deserializedValue;
    }

    private Object resolveMessageToValue(ClientMessage message) {
        return this.clientMessageDecoder.decodeClientMessage(message);
    }

    protected void setError(Throwable error) {
        this.error = error;
    }

    protected void setDone() {
        this.done = true;
    }

    protected ClientInvocationFuture getFuture() {
        return this.future;
    }

    class DelegatingExecutionCallback<T>
    implements ExecutionCallback<ClientMessage> {
        private final ExecutionCallback<T> callback;
        private final boolean shouldDeserializeData;

        DelegatingExecutionCallback(ExecutionCallback<T> callback, boolean shouldDeserializeData) {
            this.callback = callback;
            this.shouldDeserializeData = shouldDeserializeData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ClientMessage message) {
            if (!ClientDelegatingFuture.this.done) {
                Object object = ClientDelegatingFuture.this.mutex;
                synchronized (object) {
                    if (!ClientDelegatingFuture.this.done) {
                        ClientDelegatingFuture.this.response = ClientDelegatingFuture.this.resolveMessageToValue(message);
                        if (this.shouldDeserializeData && ClientDelegatingFuture.this.deserializedValue == null) {
                            ClientDelegatingFuture.this.deserializedValue = ClientDelegatingFuture.this.serializationService.toObject(ClientDelegatingFuture.this.response);
                        }
                        ClientDelegatingFuture.this.done = true;
                    }
                }
            }
            if (this.shouldDeserializeData) {
                this.callback.onResponse(ClientDelegatingFuture.this.deserializedValue);
            } else {
                this.callback.onResponse(ClientDelegatingFuture.this.response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Throwable t) {
            if (!ClientDelegatingFuture.this.done) {
                Object object = ClientDelegatingFuture.this.mutex;
                synchronized (object) {
                    if (!ClientDelegatingFuture.this.done) {
                        ClientDelegatingFuture.this.error = t;
                        ClientDelegatingFuture.this.done = true;
                    }
                }
            }
            this.callback.onFailure(t);
        }
    }
}

