/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.AwsAddressTranslator;
import com.hazelcast.client.spi.impl.DefaultAddressTranslator;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressTranslator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.util.logging.Level;

public class DefaultClientConnectionManagerFactory
implements ClientConnectionManagerFactory {
    @Override
    public ClientConnectionManager createConnectionManager(ClientConfig config, HazelcastClientInstanceImpl client, DiscoveryService discoveryService) {
        AddressTranslator addressTranslator;
        LoggingService loggingService = client.getLoggingService();
        ILogger logger = loggingService.getLogger(HazelcastClient.class);
        ClientAwsConfig awsConfig = config.getNetworkConfig().getAwsConfig();
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressTranslator = new AwsAddressTranslator(awsConfig, loggingService);
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        } else {
            addressTranslator = discoveryService != null ? new DiscoveryAddressTranslator(discoveryService) : new DefaultAddressTranslator();
        }
        return new ClientConnectionManagerImpl(client, addressTranslator);
    }
}

