/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientNonBlockingOutputThread;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadOutOfMemoryHandler;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    protected volatile boolean alive;
    private final NonBlockingIOThreadOutOfMemoryHandler outOfMemoryHandler = new NonBlockingIOThreadOutOfMemoryHandler(){

        public void handle(OutOfMemoryError error) {
            ClientConnectionManagerImpl.this.logger.severe((Throwable)error);
        }
    };
    private final ILogger logger;
    private final int connectionTimeout;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private final HazelcastClientInstanceImpl client;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private NonBlockingIOThread inputThread;
    private NonBlockingIOThread outputThread;
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private final ConcurrentMap<Address, AuthenticationFuture> connectionsInProgress = new ConcurrentHashMap<Address, AuthenticationFuture>();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Set<ConnectionHeartbeatListener> heartbeatListeners = new CopyOnWriteArraySet<ConnectionHeartbeatListener>();
    private final LoggingService loggingService;
    private final Credentials credentials;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeout = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        HazelcastProperties hazelcastProperties = client.getProperties();
        long timeout = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_TIMEOUT);
        this.heartbeatTimeout = timeout > 0L ? timeout : (long)Integer.parseInt(ClientProperty.HEARTBEAT_TIMEOUT.getDefaultValue());
        long interval = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_INTERVAL);
        this.heartbeatInterval = interval > 0L ? interval : (long)Integer.parseInt(ClientProperty.HEARTBEAT_INTERVAL.getDefaultValue());
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.loggingService = client.getLoggingService();
        this.initializeSelectors(client);
        this.socketOptions = networkConfig.getSocketOptions();
        ClientExtension clientExtension = client.getClientExtension();
        this.socketChannelWrapperFactory = clientExtension.createSocketChannelWrapperFactory();
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
        this.logger = this.loggingService.getLogger(ClientConnectionManager.class);
        this.credentials = client.getCredentials();
    }

    protected void initializeSelectors(HazelcastClientInstanceImpl client) {
        this.inputThread = new NonBlockingIOThread(client.getThreadGroup(), client.getName() + ".thread-in", this.loggingService.getLogger(NonBlockingIOThread.class), this.outOfMemoryHandler);
        client.getMetricsRegistry().scanAndRegister((Object)this.inputThread, "tcp." + this.inputThread.getName());
        this.outputThread = new ClientNonBlockingOutputThread(client.getThreadGroup(), client.getName() + ".thread-out", this.loggingService.getLogger(ClientNonBlockingOutputThread.class), this.outOfMemoryHandler);
        client.getMetricsRegistry().scanAndRegister((Object)this.outputThread, "tcp." + this.outputThread.getName());
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.createSocketInterceptor();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public synchronized void start() {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startSelectors();
        Heartbeat heartbeat = new Heartbeat();
        this.executionService.scheduleWithRepetition(heartbeat, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    protected void startSelectors() {
        this.inputThread.start();
        this.outputThread.start();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.shutdownSelectors();
        this.connectionListeners.clear();
        this.heartbeatListeners.clear();
    }

    protected void shutdownSelectors() {
        this.inputThread.shutdown();
        this.outputThread.shutdown();
    }

    @Override
    public ClientConnection getConnection(Address target) {
        if ((target = this.addressTranslator.translate(target)) == null) {
            return null;
        }
        return (ClientConnection)this.connections.get(target);
    }

    @Override
    public Connection getOrConnect(Address address, boolean asOwner) throws IOException {
        try {
            Connection connection;
            AuthenticationFuture firstCallback;
            do {
                if ((connection = this.getConnection(address, asOwner)) != null) {
                    return connection;
                }
                firstCallback = this.triggerConnect(address, asOwner);
                connection = firstCallback.get(this.connectionTimeout);
                if (asOwner) continue;
                return connection;
            } while (!firstCallback.authenticatedAsOwner);
            return connection;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public Connection getOrTriggerConnect(Address target, boolean asOwner) {
        Connection connection = this.getConnection(target, asOwner);
        if (connection != null) {
            return connection;
        }
        this.triggerConnect(target, asOwner);
        return null;
    }

    private Connection getConnection(Address target, boolean asOwner) {
        if ((target = this.addressTranslator.translate(target)) == null) {
            throw new IllegalStateException("Address can not be null");
        }
        ClientConnection connection = (ClientConnection)this.connections.get(target);
        if (connection != null) {
            if (!asOwner) {
                return connection;
            }
            if (connection.isAuthenticatedAsOwner()) {
                return connection;
            }
        }
        return null;
    }

    private AuthenticationFuture triggerConnect(Address target, boolean asOwner) {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        AuthenticationFuture callback = new AuthenticationFuture();
        AuthenticationFuture firstCallback = this.connectionsInProgress.putIfAbsent(target, callback);
        if (firstCallback == null) {
            ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
            executionService.executeInternal(new InitConnectionTask(target, asOwner, callback));
            return callback;
        }
        return firstCallback;
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded((Connection)connection);
        }
    }

    protected ClientConnection createSocketConnection(Address address) throws IOException {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        SocketChannel socketChannel = null;
        try {
            int bufferSize;
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(this.socketOptions.isKeepAlive());
            socket.setTcpNoDelay(this.socketOptions.isTcpNoDelay());
            socket.setReuseAddress(this.socketOptions.isReuseAddress());
            if (this.socketOptions.getLingerSeconds() > 0) {
                socket.setSoLinger(true, this.socketOptions.getLingerSeconds());
            }
            if ((bufferSize = this.socketOptions.getBufferSize() * 1024) <= 0) {
                bufferSize = 32768;
            }
            socket.setSendBufferSize(bufferSize);
            socket.setReceiveBufferSize(bufferSize);
            InetSocketAddress inetSocketAddress = address.getInetSocketAddress();
            socketChannel.socket().connect(inetSocketAddress, this.connectionTimeout);
            SocketChannelWrapper socketChannelWrapper = this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
            ClientConnection clientConnection = new ClientConnection(this.client, this.inputThread, this.outputThread, this.connectionIdGen.incrementAndGet(), socketChannelWrapper);
            socketChannel.configureBlocking(true);
            if (this.socketInterceptor != null) {
                this.socketInterceptor.onConnect(socket);
            }
            socketChannel.configureBlocking(false);
            socket.setSoTimeout(0);
            clientConnection.getReadHandler().register();
            clientConnection.init();
            return clientConnection;
        }
        catch (Exception e) {
            if (socketChannel != null) {
                socketChannel.close();
            }
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    @Override
    public void destroyConnection(Connection connection, String reason, Throwable cause) {
        Address endpoint = connection.getEndPoint();
        if (endpoint != null) {
            ClientConnection conn = (ClientConnection)this.connections.remove(endpoint);
            if (conn == null) {
                return;
            }
            conn.close(reason, cause);
            for (ConnectionListener connectionListener : this.connectionListeners) {
                connectionListener.connectionRemoved((Connection)conn);
            }
        } else {
            connection.close(reason, cause);
        }
    }

    @Override
    public void handleClientMessage(ClientMessage message, Connection connection) {
        ClientConnection conn = (ClientConnection)connection;
        ClientInvocationService invocationService = this.client.getInvocationService();
        conn.incrementPendingPacketCount();
        if (message.isFlagSet((short)1)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleClientMessage(message, connection);
        } else {
            invocationService.handleClientMessage(message, connection);
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void addConnectionHeartbeatListener(ConnectionHeartbeatListener connectionHeartbeatListener) {
        this.heartbeatListeners.add(connectionHeartbeatListener);
    }

    private void authenticate(final Address target, final ClientConnection connection, final boolean asOwner, final AuthenticationFuture callback) {
        ClientMessage clientMessage;
        SerializationService ss = this.client.getSerializationService();
        final ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        ClientPrincipal principal = clusterService.getPrincipal();
        byte serializationVersion = ((InternalSerializationService)this.client.getSerializationService()).getVersion();
        String uuid = null;
        String ownerUuid = null;
        if (principal != null) {
            uuid = principal.getUuid();
            ownerUuid = principal.getOwnerUuid();
        }
        if (this.credentials.getClass().equals(UsernamePasswordCredentials.class)) {
            UsernamePasswordCredentials cr = (UsernamePasswordCredentials)this.credentials;
            clientMessage = ClientAuthenticationCodec.encodeRequest((String)cr.getUsername(), (String)cr.getPassword(), (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion);
        } else {
            Data data = ss.toData((Object)this.credentials);
            clientMessage = ClientAuthenticationCustomCodec.encodeRequest((Data)data, (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion);
        }
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientMessage, connection);
        ClientInvocationFuture future = clientInvocation.invokeUrgent();
        future.andThen((ExecutionCallback)new ExecutionCallback<ClientMessage>(){

            public void onResponse(ClientMessage response) {
                ClientAuthenticationCodec.ResponseParameters result = ClientAuthenticationCodec.decodeResponse((ClientMessage)response);
                AuthenticationStatus authenticationStatus = AuthenticationStatus.getById((int)result.status);
                switch (authenticationStatus) {
                    case AUTHENTICATED: {
                        connection.setRemoteEndpoint(result.address);
                        if (asOwner) {
                            connection.setIsAuthenticatedAsOwner();
                            clusterService.setPrincipal(new ClientPrincipal(result.uuid, result.ownerUuid));
                        }
                        ClientConnectionManagerImpl.this.authenticated(target, connection);
                        callback.onSuccess(connection, asOwner);
                        break;
                    }
                    case CREDENTIALS_FAILED: {
                        AuthenticationException e = new AuthenticationException("Invalid credentials!");
                        ClientConnectionManagerImpl.this.failed(target, connection, (Throwable)e);
                        callback.onFailure((Throwable)e);
                        break;
                    }
                    default: {
                        AuthenticationException exception = new AuthenticationException("Authentication status code not supported. status:" + authenticationStatus);
                        ClientConnectionManagerImpl.this.failed(target, connection, (Throwable)exception);
                        callback.onFailure((Throwable)exception);
                    }
                }
            }

            public void onFailure(Throwable t) {
                ClientConnectionManagerImpl.this.failed(target, connection, t);
                callback.onFailure(t);
            }
        }, this.executionService.getInternalExecutor());
    }

    private void authenticated(Address target, ClientConnection connection) {
        ClientConnection oldConnection = this.connections.put(connection.getRemoteEndpoint(), connection);
        if (oldConnection == null) {
            this.fireConnectionAddedEvent(connection);
        }
        assert (oldConnection == null || connection.equals(oldConnection));
        this.connectionsInProgress.remove(target);
    }

    private void failed(Address target, ClientConnection connection, Throwable cause) {
        this.logger.finest(cause);
        this.destroyConnection(connection, null, cause);
        this.connectionsInProgress.remove(target);
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final boolean asOwner;
        private final AuthenticationFuture callback;

        InitConnectionTask(Address target, boolean asOwner, AuthenticationFuture callback) {
            this.target = target;
            this.asOwner = asOwner;
            this.callback = callback;
        }

        @Override
        public void run() {
            ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.connections.get(this.target);
            if (connection == null) {
                try {
                    connection = ClientConnectionManagerImpl.this.createSocketConnection(this.target);
                }
                catch (Exception e) {
                    ClientConnectionManagerImpl.this.logger.finest((Throwable)e);
                    this.callback.onFailure(e);
                    ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
                    return;
                }
            }
            try {
                ClientConnectionManagerImpl.this.authenticate(this.target, connection, this.asOwner, this.callback);
            }
            catch (Exception e) {
                this.callback.onFailure(e);
                ClientConnectionManagerImpl.this.destroyConnection(connection, "Failed to authenticate connection", e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
            }
        }
    }

    class Heartbeat
    implements Runnable {
        Heartbeat() {
        }

        @Override
        public void run() {
            if (!ClientConnectionManagerImpl.this.alive) {
                return;
            }
            long now = Clock.currentTimeMillis();
            for (final ClientConnection connection : ClientConnectionManagerImpl.this.connections.values()) {
                if (now - connection.lastReadTimeMillis() > ClientConnectionManagerImpl.this.heartbeatTimeout && connection.isHeartBeating()) {
                    ClientConnectionManagerImpl.this.logger.warning("Heartbeat failed to connection : " + connection);
                    connection.onHeartbeatFailed();
                    this.fireHeartbeatStopped(connection);
                }
                if (now - connection.lastReadTimeMillis() > ClientConnectionManagerImpl.this.heartbeatInterval) {
                    ClientMessage request = ClientPingCodec.encodeRequest();
                    ClientInvocation clientInvocation = new ClientInvocation(ClientConnectionManagerImpl.this.client, request, connection);
                    clientInvocation.setBypassHeartbeatCheck(true);
                    connection.onHeartbeatRequested();
                    clientInvocation.invokeUrgent().andThen((ExecutionCallback)new ExecutionCallback<ClientMessage>(){

                        public void onResponse(ClientMessage response) {
                            connection.onHeartbeatReceived();
                        }

                        public void onFailure(Throwable t) {
                            ClientConnectionManagerImpl.this.logger.warning("Error receiving heartbeat for connection: " + connection, t);
                        }
                    });
                    continue;
                }
                if (connection.isHeartBeating()) continue;
                ClientConnectionManagerImpl.this.logger.warning("Heartbeat is back to healthy for connection : " + connection);
                connection.onHeartbeatResumed();
                this.fireHeartbeatResumed(connection);
            }
        }

        private void fireHeartbeatResumed(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartbeatResumed(connection);
            }
        }

        private void fireHeartbeatStopped(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartbeatStopped(connection);
            }
        }
    }

    private static class AuthenticationFuture {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private Connection connection;
        private Throwable throwable;
        private boolean authenticatedAsOwner;

        private AuthenticationFuture() {
        }

        public void onSuccess(Connection connection, boolean asOwner) {
            this.connection = connection;
            this.authenticatedAsOwner = asOwner;
            this.countDownLatch.countDown();
        }

        public void onFailure(Throwable throwable) {
            this.throwable = throwable;
            this.countDownLatch.countDown();
        }

        Connection get(int timeout) throws Throwable {
            if (!this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Authentication response did not come back in " + timeout + " millis");
            }
            if (this.connection != null) {
                return this.connection;
            }
            throw this.throwable;
        }
    }
}

