/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.executor.CompletableFutureTask;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.util.executor.LoggingScheduledExecutor;
import com.hazelcast.util.executor.ManagedExecutorService;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService {
    public static final HazelcastProperty INTERNAL_EXECUTOR_POOL_SIZE = new HazelcastProperty("hazelcast.client.internal.executor.pool.size", Integer.valueOf(3));
    private static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final ILogger logger;
    private final ExecutorService userExecutor;
    private final ScheduledExecutorService internalExecutor;

    public ClientExecutionServiceImpl(String name, ThreadGroup threadGroup, ClassLoader classLoader, HazelcastProperties properties, int poolSize, LoggingService loggingService) {
        int executorPoolSize;
        int internalPoolSize = properties.getInteger(INTERNAL_EXECUTOR_POOL_SIZE);
        if (internalPoolSize <= 0) {
            internalPoolSize = Integer.parseInt(INTERNAL_EXECUTOR_POOL_SIZE.getDefaultValue());
        }
        if ((executorPoolSize = poolSize) <= 0) {
            executorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        this.logger = loggingService.getLogger(ClientExecutionService.class);
        this.internalExecutor = new LoggingScheduledExecutor(this.logger, internalPoolSize, (ThreadFactory)new PoolExecutorThreadFactory(threadGroup, name + ".internal-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                ClientExecutionServiceImpl.this.logger.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.userExecutor = new ThreadPoolExecutor(executorPoolSize, executorPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new PoolExecutorThreadFactory(threadGroup, name + ".user-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                ClientExecutionServiceImpl.this.logger.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
    }

    public void executeInternal(Runnable runnable) {
        this.internalExecutor.execute(runnable);
    }

    public <T> ICompletableFuture<T> submitInternal(Runnable runnable) {
        CompletableFutureTask futureTask = new CompletableFutureTask(runnable, null, (ExecutorService)this.internalExecutor);
        this.internalExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    @Override
    public void execute(Runnable command) {
        this.userExecutor.execute(command);
    }

    @Override
    public ICompletableFuture<?> submit(Runnable task) {
        CompletableFutureTask futureTask = new CompletableFutureTask(task, null, this.getAsyncExecutor());
        this.userExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    @Override
    public <T> ICompletableFuture<T> submit(Callable<T> task) {
        CompletableFutureTask futureTask = new CompletableFutureTask(task, this.getAsyncExecutor());
        this.userExecutor.submit((Runnable)futureTask);
        return futureTask;
    }

    public ManagedExecutorService register(String name, int poolSize, int queueCapacity, ExecutorType type) {
        throw new UnsupportedOperationException();
    }

    public ManagedExecutorService getExecutor(String name) {
        throw new UnsupportedOperationException();
    }

    public void shutdownExecutor(String name) {
        throw new UnsupportedOperationException();
    }

    public void execute(String name, Runnable command) {
        this.execute(command);
    }

    public Future<?> submit(String name, Runnable task) {
        return this.submit(task);
    }

    public <T> Future<T> submit(String name, Callable<T> task) {
        return this.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.internalExecutor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> schedule(String name, Runnable command, long delay, TimeUnit unit) {
        return this.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithRepetition(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.internalExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithRepetition(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithRepetition(command, initialDelay, period, unit);
    }

    public TaskScheduler getGlobalTaskScheduler() {
        throw new UnsupportedOperationException();
    }

    public TaskScheduler getTaskScheduler(String name) {
        throw new UnsupportedOperationException();
    }

    public <V> ICompletableFuture<V> asCompletableFuture(Future<V> future) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutorService getAsyncExecutor() {
        return this.userExecutor;
    }

    public ExecutorService getInternalExecutor() {
        return this.internalExecutor;
    }

    public void shutdown() {
        ClientExecutionServiceImpl.shutdownExecutor("user", this.userExecutor, this.logger);
        ClientExecutionServiceImpl.shutdownExecutor("internal", this.internalExecutor, this.logger);
    }

    public static void shutdownExecutor(String name, ExecutorService executor, ILogger logger) {
        executor.shutdown();
        try {
            boolean success = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                logger.warning(name + " executor awaitTermination could not complete in " + 30L + " seconds");
            }
        }
        catch (InterruptedException e) {
            logger.warning(name + " executor await termination is interrupted", (Throwable)e);
        }
    }
}

