/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.metrics.DiscardableMetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.IOThreadingModel;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnection
implements SocketConnection,
DiscardableMetricsProvider {
    @Probe
    private final int connectionId;
    private final ILogger logger;
    private final AtomicInteger pendingPacketCount = new AtomicInteger(0);
    private final SocketWriter writer;
    private final SocketReader reader;
    private final SocketChannelWrapper socketChannel;
    private final ClientConnectionManagerImpl connectionManager;
    private final LifecycleService lifecycleService;
    private final HazelcastClientInstanceImpl client;
    private volatile Address remoteEndpoint;
    private volatile boolean isHeartBeating = true;
    private volatile long lastHeartbeatRequestedMillis;
    private volatile long lastHeartbeatReceivedMillis;
    private boolean isAuthenticatedAsOwner;
    @Probe(level=ProbeLevel.DEBUG)
    private final AtomicLong closedTime = new AtomicLong();
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private int connectedServerVersion = -1;
    private String connectedServerVersionString;
    private List<Member> clientUnregisteredMembers;

    public ClientConnection(HazelcastClientInstanceImpl client, IOThreadingModel ioThreadingModel, int connectionId, SocketChannelWrapper socketChannel) throws IOException {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.socketChannel = socketChannel;
        this.connectionId = connectionId;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
        this.reader = ioThreadingModel.newSocketReader((SocketConnection)this);
        this.writer = ioThreadingModel.newSocketWriter((SocketConnection)this);
    }

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId) throws IOException {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.writer = null;
        this.reader = null;
        this.socketChannel = null;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    public void provideMetrics(MetricsRegistry registry) {
        Socket socket = this.socketChannel.socket();
        String connectionName = "tcp.connection[" + socket.getLocalSocketAddress() + " -> " + socket.getRemoteSocketAddress() + "]";
        registry.scanAndRegister((Object)this, connectionName);
        registry.scanAndRegister((Object)this.reader, connectionName + ".in");
        registry.scanAndRegister((Object)this.writer, connectionName + ".out");
    }

    public void discardMetrics(MetricsRegistry registry) {
        registry.deregister((Object)this);
        registry.deregister((Object)this.reader);
        registry.deregister((Object)this.writer);
    }

    public SocketReader getSocketReader() {
        return this.reader;
    }

    public SocketWriter getSocketWriter() {
        return this.writer;
    }

    public SocketChannelWrapper getSocketChannel() {
        return this.socketChannel;
    }

    public void incrementPendingPacketCount() {
        this.pendingPacketCount.incrementAndGet();
    }

    public void decrementPendingPacketCount() {
        this.pendingPacketCount.decrementAndGet();
    }

    public int getPendingPacketCount() {
        return this.pendingPacketCount.get();
    }

    public boolean write(OutboundFrame frame) {
        if (!this.isAlive()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, dropping frame -> " + frame);
            }
            return false;
        }
        this.writer.write(frame);
        return true;
    }

    public void start() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(3);
        buffer.put(StringUtil.stringToBytes((String)"CB2"));
        buffer.flip();
        this.socketChannel.write(buffer);
        this.reader.init();
    }

    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    public boolean isAlive() {
        return this.closedTime.get() == 0L;
    }

    public long lastReadTimeMillis() {
        return this.reader.lastReadTimeMillis();
    }

    public long lastWriteTimeMillis() {
        return this.writer.lastWriteTimeMillis();
    }

    public void setType(ConnectionType type) {
    }

    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    public boolean isClient() {
        return true;
    }

    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
    }

    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getLocalSocketAddress();
    }

    public void close(String reason, Throwable cause) {
        if (!this.closedTime.compareAndSet(0L, System.currentTimeMillis())) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        String message = this + " lost. Reason: ";
        message = cause != null ? message + cause.getClass().getName() + '[' + cause.getMessage() + ']' : message + "Socket explicitly closed";
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning("Exception while closing connection" + e.getMessage());
        }
        if (this.lifecycleService.isRunning()) {
            this.logger.warning(message);
        } else {
            this.logger.finest(message);
        }
        this.connectionManager.onClose((Connection)this);
        this.client.getMetricsRegistry().discardMetrics(new Object[]{this});
    }

    protected void innerClose() throws IOException {
        if (this.socketChannel.isOpen()) {
            this.socketChannel.close();
        }
        this.reader.close();
        this.writer.close();
    }

    public Throwable getCloseCause() {
        return this.closeCause;
    }

    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="incremented in single thread")
    void onHeartbeatFailed() {
        this.isHeartBeating = false;
    }

    void onHeartbeatResumed() {
        this.isHeartBeating = true;
    }

    void onHeartbeatReceived() {
        this.lastHeartbeatReceivedMillis = Clock.currentTimeMillis();
    }

    void onHeartbeatRequested() {
        this.lastHeartbeatRequestedMillis = Clock.currentTimeMillis();
    }

    public boolean isHeartBeating() {
        return this.isAlive() && this.isHeartBeating;
    }

    public boolean isAuthenticatedAsOwner() {
        return this.isAuthenticatedAsOwner;
    }

    public void setIsAuthenticatedAsOwner() {
        this.isAuthenticatedAsOwner = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        return "ClientConnection{alive=" + this.isAlive() + ", connectionId=" + this.connectionId + ", socketChannel=" + this.socketChannel + ", remoteEndpoint=" + this.remoteEndpoint + ", lastReadTime=" + StringUtil.timeToStringFriendly((long)this.lastReadTimeMillis()) + ", lastWriteTime=" + StringUtil.timeToStringFriendly((long)this.lastWriteTimeMillis()) + ", closedTime=" + StringUtil.timeToStringFriendly((long)this.closedTime.get()) + ", lastHeartbeatRequested=" + StringUtil.timeToStringFriendly((long)this.lastHeartbeatRequestedMillis) + ", lastHeartbeatReceived=" + StringUtil.timeToStringFriendly((long)this.lastHeartbeatReceivedMillis) + ", connected server version=" + this.connectedServerVersionString + '}';
    }

    public long getClosedTime() {
        return this.closedTime.get();
    }

    public void setConnectedServerVersion(String connectedServerVersion) {
        this.connectedServerVersionString = connectedServerVersion;
        this.connectedServerVersion = BuildInfo.calculateVersion((String)connectedServerVersion);
    }

    public int getConnectedServerVersion() {
        return this.connectedServerVersion;
    }

    public String getConnectedServerVersionString() {
        return this.connectedServerVersionString;
    }

    public List<Member> getClientUnregisteredMembers() {
        return this.clientUnregisteredMembers;
    }

    public void setClientUnregisteredMembers(List<Member> clientUnregisteredMembers) {
        this.clientUnregisteredMembers = clientUnregisteredMembers;
    }
}

