/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageReadHandler;
import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import java.io.IOException;

class ClientSocketReaderInitializer
implements SocketReaderInitializer<ClientConnection> {
    private final int bufferSize;
    private final boolean direct;

    ClientSocketReaderInitializer(int bufferSize, boolean direct) {
        this.bufferSize = bufferSize;
        this.direct = direct;
    }

    public void init(final ClientConnection connection, SocketReader reader) throws IOException {
        reader.initInputBuffer(IOUtil.newByteBuffer((int)this.bufferSize, (boolean)this.direct));
        ClientMessageReadHandler readHandler = new ClientMessageReadHandler(reader.getNormalFramesReadCounter(), new ClientMessageReadHandler.MessageHandler(){
            private final ClientConnectionManager connectionManager;
            {
                this.connectionManager = connection.getConnectionManager();
            }

            public void handleMessage(ClientMessage message) {
                this.connectionManager.handleClientMessage(message, (Connection)connection);
            }
        });
        reader.initReadHandler((ReadHandler)readHandler);
    }
}

