/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.CallbackAwareClientDelegatingFuture;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheClearCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheReplaceCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    private static final ClientMessageDecoder GET_AND_REMOVE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndRemoveCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder REMOVE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CacheRemoveCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    private static final ClientMessageDecoder REPLACE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_REPLACE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CachePutCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_IF_ABSENT_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CachePutIfAbsentCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    protected HazelcastClientCacheManager cacheManager;
    protected NearCacheManager nearCacheManager;
    protected NearCache<Object, Object> nearCache;
    protected String nearCacheMembershipRegistrationId;
    protected ClientCacheStatisticsImpl statistics;
    protected boolean statisticsEnabled;
    protected boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<String, Closeable> closeableListeners;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;
    private final int minConsistentNearCacheSupportingServerVersion = BuildInfo.calculateVersion((String)"3.8");

    protected AbstractClientInternalCacheProxy(CacheConfig<K, V> cacheConfig) {
        super(cacheConfig);
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.closeableListeners = new ConcurrentHashMap<String, Closeable>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.nearCacheManager = this.clientContext.getNearCacheManager();
        this.initNearCache();
        this.statistics = this.nearCache != null ? new ClientCacheStatisticsImpl(System.currentTimeMillis(), this.nearCache.getNearCacheStats()) : new ClientCacheStatisticsImpl(System.currentTimeMillis());
        this.statisticsEnabled = this.cacheConfig.isStatisticsEnabled();
    }

    void setCacheManager(HazelcastClientCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected void postDestroy() {
        if (this.cacheManager != null) {
            this.cacheManager.destroyCache(this.getName());
        }
    }

    void initNearCache() {
        ClientConfig clientConfig = this.clientContext.getClientConfig();
        NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            AbstractClientInternalCacheProxy.checkNearCacheConfig(nearCacheConfig, clientConfig.getNativeMemoryConfig());
            this.cacheOnUpdate = AbstractClientInternalCacheProxy.isCacheOnUpdate(nearCacheConfig, this.nameWithPrefix, this.logger);
            ICacheDataStructureAdapter adapter = new ICacheDataStructureAdapter((ICache)this);
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, (DataStructureAdapter)adapter);
            this.registerInvalidationListener();
        }
    }

    private static void checkNearCacheConfig(NearCacheConfig nearCacheConfig, NativeMemoryConfig nativeMemoryConfig) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat != InMemoryFormat.NATIVE) {
            return;
        }
        Preconditions.checkTrue((boolean)nativeMemoryConfig.isEnabled(), (String)"Enable native memory config to use NATIVE in-memory-format for Near Cache");
    }

    static boolean isCacheOnUpdate(NearCacheConfig nearCacheConfig, String cacheName, ILogger logger) {
        NearCacheConfig.LocalUpdatePolicy localUpdatePolicy = nearCacheConfig.getLocalUpdatePolicy();
        if (localUpdatePolicy == NearCacheConfig.LocalUpdatePolicy.CACHE) {
            logger.warning(String.format("Deprecated local update policy is found for cache `%s`. The policy `%s` is subject to remove in further releases. Instead you can use `%s`", cacheName, NearCacheConfig.LocalUpdatePolicy.CACHE, NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE));
            return true;
        }
        return localUpdatePolicy == NearCacheConfig.LocalUpdatePolicy.CACHE_ON_UPDATE;
    }

    @Override
    public void close() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
        super.close();
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, int partitionId, int completionId) {
        boolean completionOperation;
        boolean bl = completionOperation = completionId != -1;
        if (completionOperation) {
            this.registerCompletionLatch(completionId, 1);
        }
        try {
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            if (completionOperation) {
                this.waitCompletionLatch(completionId, (ICompletableFuture)f);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, Data keyData, int completionId) {
        int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
        return this.invoke(req, partitionId, completionId);
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> getAndRemoveAsyncInternal(K key, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        Data keyData = this.toData(key);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), GET_AND_REMOVE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThenInternal(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(true, start, response);
                }

                public void onFailure(Throwable t) {
                }
            }, true);
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), REMOVE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThenInternal(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(false, start, response);
                }

                public void onFailure(Throwable t) {
                }
            }, true);
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnRemove(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
        }
    }

    protected <T> ICompletableFuture<T> replaceInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), REPLACE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThenInternal(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(false, start, response);
                }

                public void onFailure(Throwable t) {
                }
            }, true);
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> replaceAndGetAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), GET_AND_REPLACE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThenInternal(new ExecutionCallback<T>(){

                public void onResponse(T response) {
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(true, start, response);
                }

                public void onFailure(Throwable t) {
                }
            }, true);
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnReplace(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    protected Object putInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (boolean)isGet, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        if (async) {
            return this.putInternalAsync(value, isGet, start, keyData, valueData, future);
        }
        return this.putInternalSync(value, isGet, start, keyData, valueData, future);
    }

    protected long tryReserveForUpdate(Data keyData) {
        if (this.nearCache == null) {
            return -1L;
        }
        return this.nearCache.tryReserveForUpdate((Object)keyData);
    }

    protected void releaseRemainingReservedKeys(Map<Data, Long> reservedKeys) {
        if (this.nearCache == null) {
            return;
        }
        for (Data key : reservedKeys.keySet()) {
            this.nearCache.remove((Object)key);
        }
    }

    private Object putInternalAsync(final V value, final boolean isGet, final long start, final Data keyData, final Data valueData, ClientInvocationFuture future) {
        OneShotExecutionCallback oneShotExecutionCallback = null;
        if (this.nearCache != null || this.statisticsEnabled) {
            oneShotExecutionCallback = new OneShotExecutionCallback<V>(){

                @Override
                protected void onResponseInternal(V responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value, -1L, AbstractClientInternalCacheProxy.this.cacheOnUpdate);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPut(isGet, start, responseData);
                    }
                }

                @Override
                protected void onFailureInternal(Throwable t) {
                }
            };
        }
        SerializationService serializationService = this.clientContext.getSerializationService();
        if (oneShotExecutionCallback == null) {
            return new ClientDelegatingFuture(future, serializationService, PUT_RESPONSE_DECODER);
        }
        CallbackAwareClientDelegatingFuture delegatingFuture = new CallbackAwareClientDelegatingFuture(future, serializationService, PUT_RESPONSE_DECODER, oneShotExecutionCallback);
        delegatingFuture.andThenInternal(oneShotExecutionCallback, true);
        return delegatingFuture;
    }

    private Object putInternalSync(V value, boolean isGet, long start, Data keyData, Data valueData, ClientInvocationFuture future) {
        try {
            ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), PUT_RESPONSE_DECODER);
            Object response = delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnPut(isGet, start, response);
            }
            Object v = response;
            return v;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
        finally {
            if (this.nearCache != null) {
                if (this.cacheOnUpdate) {
                    this.storeInNearCache(keyData, valueData, value, -1L, this.cacheOnUpdate);
                } else {
                    this.invalidateNearCache(keyData);
                }
            }
        }
    }

    protected void handleStatisticsOnPut(boolean isGet, long start, Object response) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(System.nanoTime() - start);
        if (isGet) {
            Object resp = this.clientContext.getSerializationService().toObject(response);
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (resp == null) {
                this.statistics.increaseCacheMisses();
            } else {
                this.statistics.increaseCacheHits();
            }
        }
    }

    protected Object putIfAbsentInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutIfAbsentCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow((Throwable)t);
        }
        ClientDelegatingFuture<Boolean> delegatingFuture = new ClientDelegatingFuture<Boolean>(future, this.clientContext.getSerializationService(), PUT_IF_ABSENT_RESPONSE_DECODER);
        if (async) {
            return this.putIfAbsentInternalAsync(value, start, keyData, valueData, delegatingFuture);
        }
        return this.putIfAbsentInternalSync(value, start, keyData, valueData, delegatingFuture);
    }

    private Object putIfAbsentInternalAsync(final V value, final long start, final Data keyData, final Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture) {
        if (this.nearCache != null || this.statisticsEnabled) {
            delegatingFuture.andThenInternal(new ExecutionCallback<Boolean>(){

                public void onResponse(Boolean responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value, -1L, AbstractClientInternalCacheProxy.this.cacheOnUpdate);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject((Object)responseData);
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPutIfAbsent(start, (Boolean)response);
                    }
                }

                public void onFailure(Throwable t) {
                }
            }, true);
        }
        return delegatingFuture;
    }

    private Object putIfAbsentInternalSync(V value, long start, Data keyData, Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture) {
        try {
            Boolean response = delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnPutIfAbsent(start, response);
            }
            Boolean bl = response;
            return bl;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
        finally {
            if (this.nearCache != null) {
                if (this.cacheOnUpdate) {
                    this.storeInNearCache(keyData, valueData, value, -1L, this.cacheOnUpdate);
                } else {
                    this.invalidateNearCache(keyData);
                }
            }
        }
    }

    protected void handleStatisticsOnPutIfAbsent(long start, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
    }

    protected void removeAllKeysInternal(Set<? extends K> keys) {
        long start = System.nanoTime();
        HashSet<Data> keysData = new HashSet<Data>();
        for (K key : keys) {
            CacheProxyUtil.validateNotNull(key);
            keysData.add(this.toData(key));
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllKeysCodec.encodeRequest((String)this.nameWithPrefix, keysData, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.increaseCacheRemovals(keysData.size());
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void removeAllInternal() {
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllCodec.encodeRequest((String)this.nameWithPrefix, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void clearInternal() {
        ClientMessage request = CacheClearCodec.encodeRequest((String)this.nameWithPrefix);
        try {
            this.invoke(request);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value, long reservationId, boolean cacheOnUpdate) {
        if (this.nearCache == null) {
            return;
        }
        if (cacheOnUpdate) {
            Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
            this.nearCache.put((Object)key, valueToStore);
            return;
        }
        if (reservationId != -1L) {
            if (valueData == null) {
                this.nearCache.remove((Object)key);
            } else {
                Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
                this.nearCache.tryPublishReserved((Object)key, valueToStore, reservationId, false);
            }
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache == null || key == null) {
            return;
        }
        this.nearCache.remove((Object)key);
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, CacheEventListenerAdaptor<K, V> adaptor) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
        CacheEntryListener entryListener = adaptor.getCacheEntryListener();
        if (entryListener instanceof Closeable) {
            this.closeableListeners.putIfAbsent(regId, (Closeable)entryListener);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        String registrationId = (String)regs.remove(cacheEntryListenerConfiguration);
        if (registrationId != null) {
            Closeable closeable = (Closeable)this.closeableListeners.remove(registrationId);
            IOUtil.closeResource((Closeable)closeable);
        }
        return registrationId;
    }

    protected String getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.get(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        ClientListenerService listenerService = this.clientContext.getListenerService();
        for (String regId : listenerRegistrations) {
            listenerService.deregisterListener(regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
        for (Closeable closeable : this.closeableListeners.values()) {
            IOUtil.closeResource((Closeable)closeable);
        }
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void countDownCompletionLatch(int countDownLatchId) {
        if (countDownLatchId != -1) {
            CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                this.deregisterCompletionLatch(countDownLatchId);
            }
        }
    }

    protected Integer registerCompletionLatch(Integer countDownLatchId, int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(countDownLatchId, countDownLatch);
            return countDownLatchId;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        if (countDownLatchId != -1) {
            this.syncLocks.remove(countDownLatchId);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch, ICompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                Object response;
                if (future != null && future.isDone() && (response = future.get()) instanceof Throwable) {
                    return;
                }
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
            if (countDownLatch.getCount() > 0L) {
                this.logger.finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected EventHandler createHandler(CacheEventListenerAdaptor<K, V> adaptor) {
        return new CacheEventHandler(adaptor);
    }

    public String addNearCacheInvalidationListener(EventHandler eventHandler) {
        return this.registerListener(this.createInvalidationListenerCodec(), eventHandler);
    }

    private void registerInvalidationListener() {
        if (this.nearCache == null || !this.nearCache.isInvalidatedOnChange()) {
            return;
        }
        EventHandler eventHandler = this.createInvalidationEventHandler();
        this.nearCacheMembershipRegistrationId = this.addNearCacheInvalidationListener(eventHandler);
    }

    private EventHandler createInvalidationEventHandler() {
        return new ConnectedServerVersionAwareNearCacheEventHandler();
    }

    private ListenerMessageCodec createInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                if (AbstractClientInternalCacheProxy.this.supportsRepairableNearCache()) {
                    return CacheAddNearCacheInvalidationListenerCodec.encodeRequest((String)AbstractClientInternalCacheProxy.this.nameWithPrefix, (boolean)localOnly);
                }
                return CacheAddInvalidationListenerCodec.encodeRequest((String)AbstractClientInternalCacheProxy.this.nameWithPrefix, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                if (AbstractClientInternalCacheProxy.this.supportsRepairableNearCache()) {
                    return CacheAddNearCacheInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)AbstractClientInternalCacheProxy.this.nameWithPrefix, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private int getConnectedServerVersion() {
        ClientContext clientContext = this.getContext();
        ClientClusterService clusterService = clientContext.getClusterService();
        Address ownerConnectionAddress = clusterService.getOwnerConnectionAddress();
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        Connection connection = connectionManager.getConnection(ownerConnectionAddress);
        if (connection == null) {
            this.logger.warning(String.format("No owner connection is available, near cached cache %s will be started in legacy mode", this.name));
            return -1;
        }
        return ((ClientConnection)connection).getConnectedServerVersion();
    }

    private boolean supportsRepairableNearCache() {
        return this.getConnectedServerVersion() >= this.minConsistentNearCacheSupportingServerVersion;
    }

    private void removeInvalidationListener() {
        String registrationId;
        if (this.nearCache != null && this.nearCache.isInvalidatedOnChange() && (registrationId = this.nearCacheMembershipRegistrationId) != null) {
            this.clientContext.getRepairingTask("hz:impl:cacheService").deregisterHandler(this.name);
            this.clientContext.getListenerService().deregisterListener(registrationId);
        }
    }

    private final class Pre38NearCacheEventHandler
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private String clientUuid;

        private Pre38NearCacheEventHandler() {
            this.clientUuid = AbstractClientInternalCacheProxy.this.getContext().getClusterService().getLocalClient().getUuid();
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            if (this.clientUuid.equals(sourceUuid)) {
                return;
            }
            if (key != null) {
                AbstractClientInternalCacheProxy.this.nearCache.remove((Object)key);
            } else {
                AbstractClientInternalCacheProxy.this.nearCache.clear();
            }
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            if (sourceUuids != null && !sourceUuids.isEmpty()) {
                Iterator<Data> keysIt = keys.iterator();
                Iterator<String> sourceUuidsIt = sourceUuids.iterator();
                while (keysIt.hasNext() && sourceUuidsIt.hasNext()) {
                    Data key = keysIt.next();
                    String sourceUuid = sourceUuidsIt.next();
                    if (this.clientUuid.equals(sourceUuid)) continue;
                    AbstractClientInternalCacheProxy.this.nearCache.remove((Object)key);
                }
            } else {
                for (Data key : keys) {
                    AbstractClientInternalCacheProxy.this.nearCache.remove((Object)key);
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private final class RepairableNearCacheEventHandler
    extends CacheAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final RepairingHandler repairingHandler;

        public RepairableNearCacheEventHandler() {
            this.getRepairingTask().deregisterHandler(AbstractClientInternalCacheProxy.this.nameWithPrefix);
            this.repairingHandler = this.getRepairingTask().registerAndGetHandler(AbstractClientInternalCacheProxy.this.nameWithPrefix, AbstractClientInternalCacheProxy.this.nearCache);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }

        private RepairingTask getRepairingTask() {
            ClientContext clientContext = AbstractClientInternalCacheProxy.this.getContext();
            return clientContext.getRepairingTask("hz:impl:cacheService");
        }
    }

    private final class ConnectedServerVersionAwareNearCacheEventHandler
    implements EventHandler<ClientMessage> {
        private final RepairableNearCacheEventHandler repairingEventHandler;
        private final Pre38NearCacheEventHandler pre38EventHandler;
        private volatile boolean supportsRepairableNearCache;

        private ConnectedServerVersionAwareNearCacheEventHandler() {
            this.repairingEventHandler = new RepairableNearCacheEventHandler();
            this.pre38EventHandler = new Pre38NearCacheEventHandler();
        }

        @Override
        public void beforeListenerRegister() {
            this.pre38EventHandler.beforeListenerRegister();
            this.repairingEventHandler.beforeListenerRegister();
        }

        @Override
        public void onListenerRegister() {
            this.supportsRepairableNearCache = AbstractClientInternalCacheProxy.this.supportsRepairableNearCache();
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.onListenerRegister();
            } else {
                this.pre38EventHandler.onListenerRegister();
            }
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.handle(clientMessage);
            } else {
                this.pre38EventHandler.handle(clientMessage);
            }
        }
    }

    private final class CacheEventHandler
    extends CacheAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CacheEventListenerAdaptor<K, V> adaptor;

        private CacheEventHandler(CacheEventListenerAdaptor<K, V> adaptor) {
            this.adaptor = adaptor;
        }

        public void handle(int type, Collection<CacheEventData> keys, int completionId) {
            this.adaptor.handle(type, keys, completionId);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

