/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.util.AddressHelper;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DefaultAddressProvider
implements AddressProvider {
    private ClientNetworkConfig networkConfig;
    private boolean noOtherAddressProviderExist;

    public DefaultAddressProvider(ClientNetworkConfig networkConfig, boolean noOtherAddressProviderExist) {
        this.networkConfig = networkConfig;
        this.noOtherAddressProviderExist = noOtherAddressProviderExist;
    }

    @Override
    public Collection<InetSocketAddress> loadAddresses() {
        List<String> addresses = this.networkConfig.getAddresses();
        if (addresses.isEmpty() && this.noOtherAddressProviderExist) {
            addresses.add("localhost");
        }
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        for (String address : addresses) {
            socketAddresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        return socketAddresses;
    }
}

