/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorDisposeFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorDisposeFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetResultFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetResultFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsCancelledFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsCancelledFromPartitionCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsDoneFromAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorIsDoneFromPartitionCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientScheduledFutureProxy<V>
extends ClientProxy
implements IScheduledFuture<V> {
    private ScheduledTaskHandler handler;

    ClientScheduledFutureProxy(ScheduledTaskHandler handler, ClientContext context) {
        super("hz:impl:scheduledExecutorService", handler.getSchedulerName());
        this.handler = handler;
        this.setContext(context);
    }

    public ScheduledTaskHandler getHandler() {
        return this.handler;
    }

    public ScheduledTaskStatistics getStats() {
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorGetStatsFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
                ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get();
                ScheduledExecutorGetStatsFromAddressCodec.ResponseParameters responseParameters = ScheduledExecutorGetStatsFromAddressCodec.decodeResponse((ClientMessage)response);
                return new ScheduledTaskStatisticsImpl(responseParameters.totalRuns, responseParameters.lastIdleTimeNanos, responseParameters.totalRunTimeNanos, responseParameters.totalIdleTimeNanos);
            }
            ClientMessage request = ScheduledExecutorGetStatsFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            ScheduledExecutorGetStatsFromAddressCodec.ResponseParameters responseParameters = ScheduledExecutorGetStatsFromAddressCodec.decodeResponse((ClientMessage)response);
            return new ScheduledTaskStatisticsImpl(responseParameters.totalRuns, responseParameters.lastIdleTimeNanos, responseParameters.totalRunTimeNanos, responseParameters.totalIdleTimeNanos);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public long getDelay(TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorGetDelayFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
                ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get();
                long nanos = ScheduledExecutorGetDelayFromAddressCodec.decodeResponse((ClientMessage)response).response;
                return unit.convert(nanos, TimeUnit.NANOSECONDS);
            }
            ClientMessage request = ScheduledExecutorGetDelayFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            long nanos = ScheduledExecutorGetDelayFromPartitionCodec.decodeResponse((ClientMessage)response).response;
            return unit.convert(nanos, TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public int compareTo(Delayed o) {
        throw new UnsupportedOperationException();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            throw new UnsupportedOperationException("mayInterruptIfRunning flag is not supported.");
        }
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorCancelFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address, (boolean)false);
                ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get();
                return ScheduledExecutorCancelFromAddressCodec.decodeResponse((ClientMessage)response).response;
            }
            ClientMessage request = ScheduledExecutorCancelFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName, (boolean)false);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            return ScheduledExecutorCancelFromPartitionCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean isCancelled() {
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorIsCancelledFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
                ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get();
                return ScheduledExecutorIsCancelledFromAddressCodec.decodeResponse((ClientMessage)response).response;
            }
            ClientMessage request = ScheduledExecutorIsCancelledFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            return ScheduledExecutorIsCancelledFromPartitionCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean isDone() {
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorIsDoneFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
                ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get();
                return ScheduledExecutorIsDoneFromAddressCodec.decodeResponse((ClientMessage)response).response;
            }
            ClientMessage request = ScheduledExecutorIsDoneFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            return ScheduledExecutorIsDoneFromPartitionCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private V get0(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        if (address != null) {
            ClientMessage request = ScheduledExecutorGetResultFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
            ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, address).invoke().get(timeout, unit);
            Data data = ScheduledExecutorGetResultFromAddressCodec.decodeResponse((ClientMessage)response).response;
            return (V)this.getSerializationService().toObject((Object)data);
        }
        ClientMessage request = ScheduledExecutorGetResultFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, partitionId).invoke().get(timeout, unit);
        Data data = ScheduledExecutorGetResultFromPartitionCodec.decodeResponse((ClientMessage)response).response;
        return (V)this.getSerializationService().toObject((Object)data);
    }

    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get0(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        return this.get0(timeout, unit);
    }

    public void dispose() {
        this.checkAccessibleHandler();
        Address address = this.handler.getAddress();
        String schedulerName = this.handler.getSchedulerName();
        String taskName = this.handler.getTaskName();
        int partitionId = this.handler.getPartitionId();
        try {
            if (address != null) {
                ClientMessage request = ScheduledExecutorDisposeFromAddressCodec.encodeRequest((String)schedulerName, (String)taskName, (Address)address);
                new ClientInvocation(this.getClient(), request, address).invoke().get();
            } else {
                ClientMessage request = ScheduledExecutorDisposeFromPartitionCodec.encodeRequest((String)schedulerName, (String)taskName);
                new ClientInvocation(this.getClient(), request, partitionId).invoke().get();
            }
            this.handler = null;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void checkAccessibleHandler() {
        if (this.handler == null) {
            throw new StaleTaskException("Scheduled task was previously disposed.");
        }
    }
}

