/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Iterator;

public abstract class ClientProxy
implements DistributedObject {
    protected final String name;
    private final String serviceName;
    private volatile ClientContext context;

    protected ClientProxy(String serviceName, String name) {
        this.serviceName = serviceName;
        this.name = name;
    }

    protected final String registerListener(ListenerMessageCodec codec, EventHandler handler) {
        return this.context.getListenerService().registerListener(codec, handler);
    }

    protected final boolean deregisterListener(String registrationId) {
        return this.context.getListenerService().deregisterListener(registrationId);
    }

    public final ClientContext getContext() {
        return this.context;
    }

    protected final void setContext(ClientContext context) {
        this.context = context;
    }

    protected final HazelcastClientInstanceImpl getClient() {
        return (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
    }

    protected final int getConnectedServerVersion() {
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        Collection<ClientConnection> activeConnections = connectionManager.getActiveConnections();
        Iterator<ClientConnection> iterator = activeConnections.iterator();
        if (iterator.hasNext()) {
            ClientConnection connection = iterator.next();
            return connection.getConnectedServerVersion();
        }
        return -1;
    }

    @Deprecated
    public final Object getId() {
        return this.name;
    }

    public final String getName() {
        return this.name;
    }

    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey((String)this.getDistributedObjectName());
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    protected String getDistributedObjectName() {
        return this.name;
    }

    public final void destroy() {
        if (this.preDestroy()) {
            this.onDestroy();
            ClientMessage clientMessage = ClientDestroyProxyCodec.encodeRequest((String)this.getDistributedObjectName(), (String)this.getServiceName());
            this.context.removeProxy(this);
            try {
                new ClientInvocation(this.getClient(), clientMessage).invoke().get();
                this.postDestroy();
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    protected void onInitialize() {
    }

    protected void onDestroy() {
    }

    protected boolean preDestroy() {
        return true;
    }

    protected void postDestroy() {
    }

    protected void onShutdown() {
    }

    protected <T> T invoke(ClientMessage clientMessage, Object key) {
        int partitionId = this.context.getPartitionService().getPartitionId(key);
        return this.invokeOnPartition(clientMessage, partitionId);
    }

    protected <T> T invokeOnPartition(ClientMessage clientMessage, int partitionId) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected <T> T invokeOnPartitionInterruptibly(ClientMessage clientMessage, int partitionId) throws InterruptedException {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrowAllowInterrupted((Throwable)e);
        }
    }

    protected <T> T invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    protected SerializationService getSerializationService() {
        return this.getContext().getSerializationService();
    }

    protected <T> T toObject(Object data) {
        return (T)this.getContext().getSerializationService().toObject(data);
    }

    private String getInstanceName() {
        ClientContext ctx = this.context;
        if (ctx != null) {
            HazelcastInstance instance = ctx.getHazelcastInstance();
            return instance.getName();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientProxy that = (ClientProxy)o;
        String instanceName = this.getInstanceName();
        if (!instanceName.equals(that.getInstanceName())) {
            return false;
        }
        if (!this.getDistributedObjectName().equals(that.getDistributedObjectName())) {
            return false;
        }
        return this.serviceName.equals(that.serviceName);
    }

    public int hashCode() {
        String instanceName = this.getInstanceName();
        int result = instanceName.hashCode();
        result = 31 * result + this.serviceName.hashCode();
        result = 31 * result + this.getDistributedObjectName().hashCode();
        return result;
    }
}

