/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClientNetworkConfig {
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int CONNECTION_ATTEMPT_PERIOD = 3000;
    private final List<String> addressList = new ArrayList<String>(10);
    private boolean smartRouting = true;
    private boolean redoOperation;
    private int connectionTimeout = 5000;
    private int connectionAttemptLimit = 2;
    private int connectionAttemptPeriod = 3000;
    private SocketInterceptorConfig socketInterceptorConfig;
    private SocketOptions socketOptions = new SocketOptions();
    private SSLConfig sslConfig;
    private ClientAwsConfig clientAwsConfig;
    private DiscoveryConfig discoveryConfig;

    public DiscoveryConfig getDiscoveryConfig() {
        if (this.discoveryConfig == null) {
            this.discoveryConfig = new DiscoveryConfig();
        }
        return this.discoveryConfig;
    }

    public void setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = (DiscoveryConfig)Preconditions.isNotNull((Object)discoveryConfig, (String)"discoveryConfig");
    }

    public boolean isSmartRouting() {
        return this.smartRouting;
    }

    public ClientNetworkConfig setSmartRouting(boolean smartRouting) {
        this.smartRouting = smartRouting;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public ClientNetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public int getConnectionAttemptPeriod() {
        return this.connectionAttemptPeriod;
    }

    public ClientNetworkConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        if (connectionAttemptPeriod < 0) {
            throw new IllegalArgumentException("connectionAttemptPeriod cannot be negative");
        }
        this.connectionAttemptPeriod = connectionAttemptPeriod;
        return this;
    }

    public int getConnectionAttemptLimit() {
        return this.connectionAttemptLimit;
    }

    public ClientNetworkConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        if (connectionAttemptLimit < 0) {
            throw new IllegalArgumentException("connectionAttemptLimit cannot be negative");
        }
        this.connectionAttemptLimit = connectionAttemptLimit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientNetworkConfig setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("connectionTimeout cannot be negative");
        }
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ClientNetworkConfig addAddress(String ... addresses) {
        Preconditions.isNotNull((Object)addresses, (String)"addresses");
        for (String address : addresses) {
            Preconditions.isNotNull((Object)address, (String)"address");
            Preconditions.checkHasText((String)address.trim(), (String)"address must contain text");
        }
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public ClientNetworkConfig setAddresses(List<String> addresses) {
        this.addressList.clear();
        this.addressList.addAll(addresses);
        return this;
    }

    public List<String> getAddresses() {
        return this.addressList;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public ClientNetworkConfig setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClientNetworkConfig setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public ClientNetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public ClientNetworkConfig setAwsConfig(ClientAwsConfig clientAwsConfig) {
        this.clientAwsConfig = clientAwsConfig;
        return this;
    }

    public ClientAwsConfig getAwsConfig() {
        return this.clientAwsConfig;
    }
}

