/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorDisposeResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorIsShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorRetrieveAndDisposeResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorRetrieveResultCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorSubmitToPartitionCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.durableexecutor.DurableExecutorServiceFuture;
import com.hazelcast.executor.impl.RunnableAdapter;
import com.hazelcast.nio.Bits;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ClientDurableExecutorServiceProxy
extends ClientProxy
implements DurableExecutorService {
    private static final ClientMessageDecoder RETRIEVE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)DurableExecutorRetrieveResultCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final Random random = new Random();
    private int partitionCount;

    public ClientDurableExecutorServiceProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        this.partitionCount = partitionService.getPartitionCount();
    }

    public <T> Future<T> retrieveResult(long taskId) {
        int partitionId = Bits.extractInt((long)taskId, (boolean)false);
        int sequence = Bits.extractInt((long)taskId, (boolean)true);
        ClientMessage clientMessage = DurableExecutorRetrieveResultCodec.encodeRequest((String)this.name, (int)sequence);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), RETRIEVE_RESPONSE_DECODER);
    }

    public void disposeResult(long taskId) {
        int partitionId = Bits.extractInt((long)taskId, (boolean)false);
        int sequence = Bits.extractInt((long)taskId, (boolean)true);
        ClientMessage clientMessage = DurableExecutorDisposeResultCodec.encodeRequest((String)this.name, (int)sequence);
        this.invokeOnPartition(clientMessage, partitionId);
    }

    public <T> Future<T> retrieveAndDisposeResult(long taskId) {
        int partitionId = Bits.extractInt((long)taskId, (boolean)false);
        int sequence = Bits.extractInt((long)taskId, (boolean)true);
        ClientMessage clientMessage = DurableExecutorRetrieveAndDisposeResultCodec.encodeRequest((String)this.name, (int)sequence);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), RETRIEVE_RESPONSE_DECODER);
    }

    public void execute(Runnable task) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToPartition((Callable)callable, partitionId, null);
    }

    public void executeOnKeyOwner(Runnable task, Object key) {
        int partitionId = this.getPartitionId(key);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        this.submitToPartition((Callable)callable, partitionId, null);
    }

    public <T> DurableExecutorServiceFuture<T> submitToKeyOwner(Callable<T> task, Object key) {
        int partitionId = this.getPartitionId(key);
        return this.submitToPartition(task, partitionId, null);
    }

    public DurableExecutorServiceFuture<?> submitToKeyOwner(Runnable task, Object key) {
        int partitionId = this.getPartitionId(key);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submitToPartition((Callable)callable, partitionId, null);
    }

    public <T> DurableExecutorServiceFuture<T> submit(Callable<T> task) {
        int partitionId = this.getTaskPartitionId(task);
        return this.submitToPartition(task, partitionId, null);
    }

    public <T> DurableExecutorServiceFuture<T> submit(Runnable task, T result) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter<T> callable = this.createRunnableAdapter(task);
        return this.submitToPartition((Callable<T>)callable, partitionId, result);
    }

    public DurableExecutorServiceFuture<?> submit(Runnable task) {
        int partitionId = this.getTaskPartitionId(task);
        RunnableAdapter callable = this.createRunnableAdapter(task);
        return this.submitToPartition((Callable)callable, partitionId, null);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public void shutdown() {
        ClientMessage request = DurableExecutorShutdownCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    public boolean isShutdown() {
        ClientMessage request = DurableExecutorIsShutdownCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        DurableExecutorIsShutdownCodec.ResponseParameters resultParameters = DurableExecutorIsShutdownCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isTerminated() {
        return this.isShutdown();
    }

    private <T> DurableExecutorServiceFuture<T> submitToPartition(Callable<T> task, int partitionId, T result) {
        int sequence;
        Preconditions.checkNotNull(task, (String)"task should not be null");
        ClientMessage request = DurableExecutorSubmitToPartitionCodec.encodeRequest((String)this.name, (Data)this.toData(task));
        try {
            ClientMessage response = (ClientMessage)this.invokeOnPartition(request, partitionId);
            sequence = DurableExecutorSubmitToPartitionCodec.decodeResponse((ClientMessage)response).response;
        }
        catch (Throwable t) {
            return new ClientDurableExecutorServiceCompletedFuture(t, this.getUserExecutor());
        }
        ClientMessage clientMessage = DurableExecutorRetrieveResultCodec.encodeRequest((String)this.name, (int)sequence);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
        long taskId = Bits.combineToLong((int)partitionId, (int)sequence);
        return new ClientDurableExecutorServiceDelegatingFuture<T>(future, this.getSerializationService(), RETRIEVE_RESPONSE_DECODER, result, taskId);
    }

    private Executor getUserExecutor() {
        return this.getContext().getExecutionService().getUserExecutor();
    }

    private <T> RunnableAdapter<T> createRunnableAdapter(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        return new RunnableAdapter(command);
    }

    private int getTaskPartitionId(Object task) {
        Object partitionKey;
        if (task instanceof PartitionAware && (partitionKey = ((PartitionAware)task).getPartitionKey()) != null) {
            return this.getPartitionId(partitionKey);
        }
        return this.random.nextInt(this.partitionCount);
    }

    private int getPartitionId(Object key) {
        return this.getContext().getPartitionService().getPartitionId(key);
    }

    private static final class ClientDurableExecutorServiceCompletedFuture<T>
    implements DurableExecutorServiceFuture<T> {
        private final Object result;
        private final Executor executor;

        private ClientDurableExecutorServiceCompletedFuture(Object result, Executor executor) {
            this.result = result;
            this.executor = executor;
        }

        public long getTaskId() {
            throw new IllegalStateException("Task failed to execute!");
        }

        public void andThen(ExecutionCallback<T> callback) {
            this.andThen(callback, this.executor);
        }

        public void andThen(final ExecutionCallback<T> callback, Executor executor) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (ClientDurableExecutorServiceCompletedFuture.this.result instanceof Throwable) {
                        callback.onFailure((Throwable)ClientDurableExecutorServiceCompletedFuture.this.result);
                    } else {
                        callback.onResponse(ClientDurableExecutorServiceCompletedFuture.this.result);
                    }
                }
            });
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public T get() throws InterruptedException, ExecutionException {
            if (this.result instanceof Throwable) {
                if (this.result instanceof ExecutionException) {
                    throw (ExecutionException)this.result;
                }
                if (this.result instanceof InterruptedException) {
                    throw (InterruptedException)this.result;
                }
                throw new ExecutionException((Throwable)this.result);
            }
            return (T)this.result;
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private static class ClientDurableExecutorServiceDelegatingFuture<T>
    extends ClientDelegatingFuture<T>
    implements DurableExecutorServiceFuture<T> {
        private final long taskId;

        public ClientDurableExecutorServiceDelegatingFuture(ClientInvocationFuture clientInvocationFuture, SerializationService serializationService, ClientMessageDecoder clientMessageDecoder, T defaultValue, long taskId) {
            super(clientInvocationFuture, serializationService, clientMessageDecoder, defaultValue);
            this.taskId = taskId;
        }

        public long getTaskId() {
            return this.taskId;
        }
    }
}

