/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.Clock;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class HeartbeatManager
implements Runnable {
    private ClientConnectionManagerImpl clientConnectionManager;
    private HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private final Set<ConnectionHeartbeatListener> heartbeatListeners = new CopyOnWriteArraySet<ConnectionHeartbeatListener>();

    HeartbeatManager(ClientConnectionManagerImpl clientConnectionManager, HazelcastClientInstanceImpl client) {
        this.clientConnectionManager = clientConnectionManager;
        this.client = client;
        HazelcastProperties hazelcastProperties = client.getProperties();
        long timeout = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_TIMEOUT);
        this.heartbeatTimeout = timeout > 0L ? timeout : (long)Integer.parseInt(ClientProperty.HEARTBEAT_TIMEOUT.getDefaultValue());
        long interval = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_INTERVAL);
        this.heartbeatInterval = interval > 0L ? interval : (long)Integer.parseInt(ClientProperty.HEARTBEAT_INTERVAL.getDefaultValue());
        this.logger = client.getLoggingService().getLogger(HeartbeatManager.class);
    }

    public void start() {
        ClientExecutionServiceImpl es = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        es.scheduleWithRepetition(this, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        if (!this.clientConnectionManager.alive) {
            return;
        }
        long now = Clock.currentTimeMillis();
        for (final ClientConnection connection : this.clientConnectionManager.getActiveConnections()) {
            if (!connection.isAlive()) continue;
            if (now - connection.lastReadTimeMillis() > this.heartbeatTimeout && connection.isHeartBeating()) {
                this.logger.warning("Heartbeat failed over the connection: " + connection);
                connection.onHeartbeatFailed();
                this.fireHeartbeatStopped(connection);
            }
            if (now - connection.lastReadTimeMillis() > this.heartbeatInterval) {
                ClientMessage request = ClientPingCodec.encodeRequest();
                ClientInvocation clientInvocation = new ClientInvocation(this.client, request, null, connection);
                clientInvocation.setBypassHeartbeatCheck(true);
                connection.onHeartbeatRequested();
                clientInvocation.invokeUrgent().andThen(new ExecutionCallback<ClientMessage>(){

                    public void onResponse(ClientMessage response) {
                        if (connection.isAlive()) {
                            connection.onHeartbeatReceived();
                        }
                    }

                    public void onFailure(Throwable t) {
                        if (connection.isAlive()) {
                            HeartbeatManager.this.logger.warning("Error receiving ping answer from the connection: " + connection, t);
                        }
                    }
                });
                continue;
            }
            if (connection.isHeartBeating()) continue;
            this.logger.warning("Heartbeat is back to healthy for the connection: " + connection);
            connection.onHeartbeatResumed();
            this.fireHeartbeatResumed(connection);
        }
    }

    private void fireHeartbeatResumed(ClientConnection connection) {
        for (ConnectionHeartbeatListener heartbeatListener : this.heartbeatListeners) {
            heartbeatListener.heartbeatResumed(connection);
        }
    }

    private void fireHeartbeatStopped(ClientConnection connection) {
        for (ConnectionHeartbeatListener heartbeatListener : this.heartbeatListeners) {
            heartbeatListener.heartbeatStopped(connection);
        }
    }

    public void addConnectionHeartbeatListener(ConnectionHeartbeatListener connectionHeartbeatListener) {
        this.heartbeatListeners.add(connectionHeartbeatListener);
    }

    public void shutdown() {
        this.heartbeatListeners.clear();
    }
}

