/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.eureka.one;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.eureka.one.EurekaOneProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.UuidUtil;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

class EurekaOneDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    @VisibleForTesting
    static final String DEFAULT_NAMESPACE = "hazelcast";
    @VisibleForTesting
    static final int NUM_RETRIES = 5;
    private static final int VERIFICATION_WAIT_TIMEOUT = 5;
    private static final int DISCOVERY_RETRY_TIMEOUT = 1;
    private final EurekaClient eurekaClient;
    private final ApplicationInfoManager applicationInfoManager;
    private final boolean selfRegistration = (Boolean)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.SELF_REGISTRATION, Boolean.valueOf(true));
    private final boolean clientMode;
    private final String namespace = (String)((Object)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.NAMESPACE, (Comparable)((Object)"hazelcast")));

    @VisibleForTesting
    EurekaOneDiscoveryStrategy(EurekaClient eurekaClient, ApplicationInfoManager manager, boolean clientMode) {
        super(new NoLogFactory().getLogger(EurekaOneDiscoveryStrategy.class.getName()), Collections.emptyMap());
        this.clientMode = clientMode;
        this.eurekaClient = eurekaClient;
        this.applicationInfoManager = manager;
    }

    EurekaOneDiscoveryStrategy(DiscoveryNode localNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.clientMode = localNode == null;
        this.applicationInfoManager = this.initializeApplicationInfoManager(localNode);
        this.eurekaClient = new DiscoveryClient(this.applicationInfoManager, (EurekaClientConfig)new EurekaOneAwareConfig(this.namespace));
    }

    private ApplicationInfoManager initializeApplicationInfoManager(DiscoveryNode localNode) {
        EurekaInstanceConfig instanceConfig = this.buildInstanceConfig(localNode);
        InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider(instanceConfig).get();
        ApplicationInfoManager manager = new ApplicationInfoManager(instanceConfig, instanceInfo);
        this.eurekaStatusChange(manager, InstanceInfo.InstanceStatus.STARTING);
        return manager;
    }

    private EurekaInstanceConfig buildInstanceConfig(DiscoveryNode localNode) {
        try {
            String configProperty = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client").get();
            String eurekaPropertyFile = String.format("%s.properties", configProperty);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(eurekaPropertyFile);
            if (url == null) {
                throw new IllegalStateException("Cannot locate " + eurekaPropertyFile + " as a classpath resource.");
            }
            Properties props = new Properties();
            props.load(url.openStream());
            String key = String.format("%s.datacenter", this.namespace);
            String value = props.getProperty(key, "");
            if ("cloud".equals(value.trim().toLowerCase())) {
                return new DelegatingInstanceConfig((EurekaInstanceConfig)new CloudInstanceConfig(this.namespace), localNode);
            }
            return new DelegatingInstanceConfig((EurekaInstanceConfig)new MyDataCenterInstanceConfig(this.namespace), localNode);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot build EurekaInstanceInfo", e);
        }
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        Application application = null;
        for (int i = 0; i < 5 && (application = this.eurekaClient.getApplication(applicationName)) == null; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
        if (application != null) {
            List instances = application.getInstances();
            for (InstanceInfo instance : instances) {
                InetAddress address;
                if (instance.getStatus() != InstanceInfo.InstanceStatus.UP || null == (address = this.mapAddress(instance))) continue;
                int port = instance.getPort();
                Map metadata = instance.getMetadata();
                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address, port), metadata));
            }
        }
        return nodes;
    }

    public void start() {
        this.eurekaStatusChange(InstanceInfo.InstanceStatus.UP);
        this.verifyEurekaRegistration();
    }

    public void destroy() {
        this.eurekaStatusChange(InstanceInfo.InstanceStatus.DOWN);
        if (null != this.eurekaClient) {
            this.eurekaClient.shutdown();
        }
    }

    private InetAddress mapAddress(InstanceInfo instance) {
        try {
            return InetAddress.getByName(instance.getIPAddr());
        }
        catch (UnknownHostException e) {
            this.getLogger().warning("InstanceInfo '" + instance + "' could not be resolved");
            return null;
        }
    }

    private void eurekaStatusChange(InstanceInfo.InstanceStatus status) {
        this.eurekaStatusChange(this.applicationInfoManager, status);
    }

    private void eurekaStatusChange(ApplicationInfoManager applicationInfoManager, InstanceInfo.InstanceStatus status) {
        if (this.clientMode || !this.selfRegistration) {
            return;
        }
        applicationInfoManager.setInstanceStatus(status);
    }

    @VisibleForTesting
    void verifyEurekaRegistration() {
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        while (true) {
            block6: {
                try {
                    this.getLogger().info("Waiting for registration with Eureka...");
                    Application application = this.eurekaClient.getApplication(applicationName);
                    if (application != null) {
                        break;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof Error)) break block6;
                    throw (Error)t;
                }
            }
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class DelegatingInstanceConfig
    implements EurekaInstanceConfig {
        private final EurekaInstanceConfig instanceConfig;
        private final DiscoveryNode localNode;
        private final String uuid;

        private DelegatingInstanceConfig(EurekaInstanceConfig instanceConfig, DiscoveryNode localNode) {
            this.instanceConfig = instanceConfig;
            this.localNode = localNode;
            this.uuid = UuidUtil.newSecureUuidString();
        }

        public String getInstanceId() {
            return this.uuid;
        }

        public String getAppname() {
            return this.instanceConfig.getAppname();
        }

        public String getAppGroupName() {
            return this.instanceConfig.getAppGroupName();
        }

        public boolean isInstanceEnabledOnit() {
            return this.instanceConfig.isInstanceEnabledOnit();
        }

        public int getNonSecurePort() {
            if (null == this.localNode) {
                return this.instanceConfig.getNonSecurePort();
            }
            return this.localNode.getPrivateAddress().getPort();
        }

        public int getSecurePort() {
            return this.instanceConfig.getSecurePort();
        }

        public boolean isNonSecurePortEnabled() {
            return this.instanceConfig.isNonSecurePortEnabled();
        }

        public boolean getSecurePortEnabled() {
            return this.instanceConfig.getSecurePortEnabled();
        }

        public int getLeaseRenewalIntervalInSeconds() {
            return this.instanceConfig.getLeaseRenewalIntervalInSeconds();
        }

        public int getLeaseExpirationDurationInSeconds() {
            return this.instanceConfig.getLeaseExpirationDurationInSeconds();
        }

        public String getVirtualHostName() {
            return this.instanceConfig.getVirtualHostName();
        }

        public String getSecureVirtualHostName() {
            return this.instanceConfig.getSecureVirtualHostName();
        }

        public String getASGName() {
            return this.instanceConfig.getASGName();
        }

        public String getHostName(boolean refresh) {
            return this.instanceConfig.getHostName(refresh);
        }

        public Map<String, String> getMetadataMap() {
            return this.instanceConfig.getMetadataMap();
        }

        public DataCenterInfo getDataCenterInfo() {
            return this.instanceConfig.getDataCenterInfo();
        }

        public String getIpAddress() {
            if (null == this.localNode) {
                return this.instanceConfig.getIpAddress();
            }
            return this.localNode.getPrivateAddress().getHost();
        }

        public String getStatusPageUrlPath() {
            return this.instanceConfig.getStatusPageUrlPath();
        }

        public String getStatusPageUrl() {
            return this.instanceConfig.getStatusPageUrl();
        }

        public String getHomePageUrlPath() {
            return this.instanceConfig.getHomePageUrlPath();
        }

        public String getHomePageUrl() {
            return this.instanceConfig.getHomePageUrl();
        }

        public String getHealthCheckUrlPath() {
            return this.instanceConfig.getHealthCheckUrlPath();
        }

        public String getHealthCheckUrl() {
            return this.instanceConfig.getHealthCheckUrl();
        }

        public String getSecureHealthCheckUrl() {
            return this.instanceConfig.getSecureHealthCheckUrl();
        }

        public String[] getDefaultAddressResolutionOrder() {
            return this.instanceConfig.getDefaultAddressResolutionOrder();
        }

        public String getNamespace() {
            return this.instanceConfig.getNamespace();
        }
    }

    private class EurekaOneAwareConfig
    extends DefaultEurekaClientConfig {
        EurekaOneAwareConfig(String namespace) {
            super(namespace);
        }

        public boolean shouldRegisterWithEureka() {
            return !EurekaOneDiscoveryStrategy.this.clientMode && EurekaOneDiscoveryStrategy.this.selfRegistration;
        }
    }
}

