/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.eureka.one;

import com.google.common.collect.Lists;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.eureka.one.EurekaOneDiscoveryStrategy;
import com.hazelcast.eureka.one.EurekaOneProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.netflix.discovery.EurekaClient;
import java.util.Collection;
import java.util.Map;

public class EurekaOneDiscoveryStrategyFactory
implements DiscoveryStrategyFactory {
    private static final Collection<PropertyDefinition> PROPERTY_DEFINITIONS = Lists.newArrayList((Object[])new PropertyDefinition[]{EurekaOneProperties.SELF_REGISTRATION, EurekaOneProperties.NAMESPACE});
    private static EurekaClient eurekaClient;

    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType() {
        return EurekaOneDiscoveryStrategy.class;
    }

    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        EurekaOneDiscoveryStrategy.EurekaOneDiscoveryStrategyBuilder builder = new EurekaOneDiscoveryStrategy.EurekaOneDiscoveryStrategyBuilder();
        builder.setDiscoveryNode(discoveryNode).setILogger(logger).setProperties(properties).setEurekaClient(eurekaClient);
        return builder.build();
    }

    public Collection<PropertyDefinition> getConfigurationProperties() {
        return PROPERTY_DEFINITIONS;
    }

    public static void setEurekaClient(EurekaClient eurekaClient) {
        EurekaOneDiscoveryStrategyFactory.eurekaClient = eurekaClient;
    }
}

