/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.eureka.one;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.DefaultEurekaTransportConfig;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.MapConfiguration;

public class PropertyBasedEurekaClientConfig
implements EurekaClientConfig {
    public static final String DEFAULT_ZONE = "defaultZone";
    private final String namespace;
    private final DynamicPropertyFactory configInstance;
    private final EurekaTransportConfig transportConfig;

    public PropertyBasedEurekaClientConfig(String namespace, Map<String, Object> properties) {
        DynamicPropertyFactory configInstance;
        this.namespace = namespace.endsWith(".") ? namespace : namespace + ".";
        DynamicPropertyFactory.initWithConfigurationSource((AbstractConfiguration)new MapConfiguration(properties));
        this.configInstance = configInstance = DynamicPropertyFactory.getInstance();
        this.transportConfig = new DefaultEurekaTransportConfig(namespace, configInstance);
    }

    public int getRegistryFetchIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "client.refresh.interval", 30).get();
    }

    public int getInstanceInfoReplicationIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "appinfo.replicate.interval", 30).get();
    }

    public int getInitialInstanceInfoReplicationIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "appinfo.initial.replicate.time", 40).get();
    }

    public int getEurekaServiceUrlPollIntervalSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "serviceUrlPollIntervalMs", 300000).get() / 1000;
    }

    public String getProxyHost() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyHost", null).get();
    }

    public String getProxyPort() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPort", null).get();
    }

    public String getProxyUserName() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyUserName", null).get();
    }

    public String getProxyPassword() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.proxyPassword", null).get();
    }

    public boolean shouldGZipContent() {
        return this.configInstance.getBooleanProperty(this.namespace + "eurekaServer.gzipContent", true).get();
    }

    public int getEurekaServerReadTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.readTimeout", 8).get();
    }

    public int getEurekaServerConnectTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.connectTimeout", 5).get();
    }

    public String getBackupRegistryImpl() {
        return this.configInstance.getStringProperty(this.namespace + "backupregistry", null).get();
    }

    public int getEurekaServerTotalConnections() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.maxTotalConnections", 200).get();
    }

    public int getEurekaServerTotalConnectionsPerHost() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaServer.maxConnectionsPerHost", 50).get();
    }

    public String getEurekaServerURLContext() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.context", this.configInstance.getStringProperty(this.namespace + "context", null).get()).get();
    }

    public String getEurekaServerPort() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.port", this.configInstance.getStringProperty(this.namespace + "port", null).get()).get();
    }

    public String getEurekaServerDNSName() {
        return this.configInstance.getStringProperty(this.namespace + "eurekaServer.domainName", this.configInstance.getStringProperty(this.namespace + "domainName", null).get()).get();
    }

    public boolean shouldUseDnsForFetchingServiceUrls() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldUseDns", false).get();
    }

    public boolean shouldRegisterWithEureka() {
        return this.configInstance.getBooleanProperty(this.namespace + "registration.enabled", true).get();
    }

    public boolean shouldPreferSameZoneEureka() {
        return this.configInstance.getBooleanProperty(this.namespace + "preferSameZone", true).get();
    }

    public boolean allowRedirects() {
        return this.configInstance.getBooleanProperty(this.namespace + "allowRedirects", false).get();
    }

    public boolean shouldLogDeltaDiff() {
        return this.configInstance.getBooleanProperty(this.namespace + "printDeltaFullDiff", false).get();
    }

    public boolean shouldDisableDelta() {
        return this.configInstance.getBooleanProperty(this.namespace + "disableDelta", false).get();
    }

    @Nullable
    public String fetchRegistryForRemoteRegions() {
        return this.configInstance.getStringProperty(this.namespace + "fetchRemoteRegionsRegistry", null).get();
    }

    public String getRegion() {
        DynamicStringProperty defaultEurekaRegion = this.configInstance.getStringProperty("eureka.region", "us-east-1");
        return this.configInstance.getStringProperty(this.namespace + "region", defaultEurekaRegion.get()).get();
    }

    public String[] getAvailabilityZones(String region) {
        return this.configInstance.getStringProperty(this.namespace + region + "." + "availabilityZones", DEFAULT_ZONE).get().split(",");
    }

    public List<String> getEurekaServerServiceUrls(String myZone) {
        String serviceUrls = this.configInstance.getStringProperty(this.namespace + "serviceUrl" + "." + myZone, null).get();
        if (serviceUrls == null || serviceUrls.isEmpty()) {
            serviceUrls = this.configInstance.getStringProperty(this.namespace + "serviceUrl" + ".default", null).get();
        }
        if (serviceUrls != null) {
            return Arrays.asList(serviceUrls.split(","));
        }
        return new ArrayList<String>();
    }

    public boolean shouldFilterOnlyUpInstances() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldFilterOnlyUpInstances", true).get();
    }

    public int getEurekaConnectionIdleTimeoutSeconds() {
        return this.configInstance.getIntProperty(this.namespace + "eurekaserver.connectionIdleTimeoutInSeconds", 30).get();
    }

    public boolean shouldFetchRegistry() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldFetchRegistry", true).get();
    }

    public String getRegistryRefreshSingleVipAddress() {
        return this.configInstance.getStringProperty(this.namespace + "registryRefreshSingleVipAddress", null).get();
    }

    public int getHeartbeatExecutorThreadPoolSize() {
        return this.configInstance.getIntProperty(this.namespace + "client.heartbeat.threadPoolSize", 5).get();
    }

    public int getHeartbeatExecutorExponentialBackOffBound() {
        return this.configInstance.getIntProperty(this.namespace + "client.heartbeat.exponentialBackOffBound", 10).get();
    }

    public int getCacheRefreshExecutorThreadPoolSize() {
        return this.configInstance.getIntProperty(this.namespace + "client.cacheRefresh.threadPoolSize", 5).get();
    }

    public int getCacheRefreshExecutorExponentialBackOffBound() {
        return this.configInstance.getIntProperty(this.namespace + "client.cacheRefresh.exponentialBackOffBound", 10).get();
    }

    public String getDollarReplacement() {
        return this.configInstance.getStringProperty(this.namespace + "dollarReplacement", "_-").get();
    }

    public String getEscapeCharReplacement() {
        return this.configInstance.getStringProperty(this.namespace + "escapeCharReplacement", "__").get();
    }

    public boolean shouldOnDemandUpdateStatusChange() {
        return this.configInstance.getBooleanProperty(this.namespace + "shouldOnDemandUpdateStatusChange", true).get();
    }

    public String getEncoderName() {
        return this.configInstance.getStringProperty(this.namespace + "encoderName", null).get();
    }

    public String getDecoderName() {
        return this.configInstance.getStringProperty(this.namespace + "decoderName", null).get();
    }

    public String getClientDataAccept() {
        return this.configInstance.getStringProperty(this.namespace + "clientDataAccept", EurekaAccept.full.name()).get();
    }

    public String getExperimental(String name) {
        return this.configInstance.getStringProperty(this.namespace + "experimental" + "." + name, null).get();
    }

    public EurekaTransportConfig getTransportConfig() {
        return this.transportConfig;
    }
}

