/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.eureka.one;

import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.eureka.one.DefaultUpdater;
import com.hazelcast.eureka.one.EurekaOneProperties;
import com.hazelcast.eureka.one.MetadataUpdater;
import com.hazelcast.eureka.one.NoopUpdater;
import com.hazelcast.eureka.one.PropertyBasedEurekaClientConfig;
import com.hazelcast.eureka.one.StatusChangeStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.NoLogFactory;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.UuidUtil;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

final class EurekaOneDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    @VisibleForTesting
    static final String DEFAULT_NAMESPACE = "hazelcast";
    @VisibleForTesting
    static final int NUM_RETRIES = 5;
    private static final int VERIFICATION_WAIT_TIMEOUT = 5;
    private static final int DISCOVERY_RETRY_TIMEOUT = 1;
    private final EurekaClient eurekaClient;
    private final String groupName;
    private final ApplicationInfoManager applicationInfoManager;
    private final Boolean useClasspathEurekaClientProps;
    private final String namespace = (String)((Object)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.NAMESPACE, (Comparable)((Object)"hazelcast")));
    private StatusChangeStrategy statusChangeStrategy;
    private final Boolean skipEurekaRegistrationVerification;
    private final Boolean useMetadataForHostAndPort;

    private EurekaOneDiscoveryStrategy(EurekaOneDiscoveryStrategyBuilder builder) {
        super(builder.logger, builder.properties);
        boolean selfRegistration = (Boolean)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.SELF_REGISTRATION, Boolean.valueOf(true));
        this.useMetadataForHostAndPort = (Boolean)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.USE_METADATA_FOR_HOST_AND_PORT, Boolean.valueOf(false));
        this.skipEurekaRegistrationVerification = (Boolean)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.SKIP_EUREKA_REGISTRATION_VERIFICATION, Boolean.valueOf(false));
        this.useClasspathEurekaClientProps = (Boolean)this.getOrDefault("hazelcast.eurekaone", EurekaOneProperties.USE_CLASSPATH_EUREKA_CLIENT_PROPS, Boolean.valueOf(true));
        String string = this.groupName = builder.groupName != null ? builder.groupName : "dev";
        this.statusChangeStrategy = !selfRegistration && this.useMetadataForHostAndPort == false ? new NoopUpdater() : (this.useMetadataForHostAndPort != false ? new MetadataUpdater(builder.discoveryNode, selfRegistration, this.groupName) : builder.changeStrategy);
        this.applicationInfoManager = builder.applicationInfoManager == null ? this.initializeApplicationInfoManager(builder.discoveryNode) : builder.applicationInfoManager;
        if (builder.eurekaClient == null) {
            Object eurekaClientConfig = this.useClasspathEurekaClientProps != false ? new EurekaOneAwareConfig(this.namespace) : new PropertyBasedEurekaClientConfig(this.namespace, this.getEurekaClientProperties(this.namespace, this.getProperties()));
            this.eurekaClient = new DiscoveryClient(this.applicationInfoManager, (EurekaClientConfig)eurekaClientConfig);
        } else {
            this.eurekaClient = builder.eurekaClient;
        }
    }

    private Map<String, Object> getEurekaClientProperties(String namespace, Map<String, Comparable> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Comparable> e : properties.entrySet()) {
            result.put(namespace + "." + e.getKey(), e.getValue());
        }
        for (PropertyDefinition p : EurekaOneProperties.HZ_PROPERTY_DEFINITIONS) {
            result.remove(namespace + "." + p.key());
        }
        return result;
    }

    private ApplicationInfoManager initializeApplicationInfoManager(DiscoveryNode localNode) {
        EurekaInstanceConfig instanceConfig = this.buildInstanceConfig(localNode);
        InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider(instanceConfig).get();
        ApplicationInfoManager manager = new ApplicationInfoManager(instanceConfig, instanceInfo);
        this.statusChangeStrategy.update(manager, InstanceInfo.InstanceStatus.STARTING);
        return manager;
    }

    private EurekaInstanceConfig buildInstanceConfig(DiscoveryNode localNode) {
        try {
            String value;
            if (this.useClasspathEurekaClientProps.booleanValue()) {
                String configProperty = DynamicPropertyFactory.getInstance().getStringProperty("eureka.client.props", "eureka-client").get();
                String eurekaPropertyFile = String.format("%s.properties", configProperty);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                URL url = loader.getResource(eurekaPropertyFile);
                if (url == null) {
                    throw new IllegalStateException("Cannot locate " + eurekaPropertyFile + " as a classpath resource.");
                }
                Properties props = new Properties();
                props.load(url.openStream());
                String key = String.format("%s.datacenter", this.namespace);
                value = props.getProperty(key, "");
            } else {
                value = String.valueOf(this.getProperties().get("datacenter"));
            }
            if ("cloud".equals(value.trim().toLowerCase())) {
                return new DelegatingInstanceConfig((EurekaInstanceConfig)new CloudInstanceConfig(this.namespace), localNode);
            }
            return new DelegatingInstanceConfig((EurekaInstanceConfig)new MyDataCenterInstanceConfig(this.namespace), localNode);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot build EurekaInstanceInfo", e);
        }
    }

    private String getGroupNameFromMetadata(Map<String, String> metadata) {
        String groupName = "dev";
        if (metadata.containsKey("hazelcast.groupName")) {
            groupName = metadata.get("hazelcast.groupName");
        }
        return groupName;
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        Application application = null;
        for (int i = 0; i < 5 && (application = this.eurekaClient.getApplication(applicationName)) == null; ++i) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
        if (application != null) {
            List instances = application.getInstancesAsIsFromEureka();
            for (InstanceInfo instance : instances) {
                Map metadata;
                if (instance.getStatus() != InstanceInfo.InstanceStatus.UP) continue;
                Map properties = metadata = instance.getMetadata();
                if (this.useMetadataForHostAndPort.booleanValue()) {
                    this.addNodeUsingMetadata(nodes, instance, metadata, properties);
                    continue;
                }
                this.addNode(nodes, instance, properties);
            }
        }
        return nodes;
    }

    private void addNodeUsingMetadata(List<DiscoveryNode> nodes, InstanceInfo instance, Map<String, String> metadata, Map<String, Object> properties) {
        if (this.getGroupNameFromMetadata(metadata).equals(this.groupName)) {
            InetAddress address = this.mapAddress(instance);
            int port = this.mapPort(instance);
            if (address != null) {
                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address, port), properties));
            }
        }
    }

    private void addNode(List<DiscoveryNode> nodes, InstanceInfo instance, Map<String, Object> properties) {
        InetAddress address = this.mapAddress(instance);
        if (null == address) {
            return;
        }
        int port = instance.getPort();
        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address, port), properties));
    }

    public void start() {
        this.statusChangeStrategy.update(this.applicationInfoManager, InstanceInfo.InstanceStatus.UP);
        if (!this.skipEurekaRegistrationVerification.booleanValue()) {
            this.verifyEurekaRegistration();
        }
    }

    public void destroy() {
        this.statusChangeStrategy.update(this.applicationInfoManager, InstanceInfo.InstanceStatus.DOWN);
        if (null != this.eurekaClient) {
            this.eurekaClient.shutdown();
        }
    }

    private InetAddress mapAddress(InstanceInfo instance) {
        try {
            if (this.useMetadataForHostAndPort.booleanValue()) {
                Map metadata = instance.getMetadata();
                return InetAddress.getByName((String)metadata.get("hazelcast.host"));
            }
            return InetAddress.getByName(instance.getIPAddr());
        }
        catch (UnknownHostException e) {
            this.getLogger().warning("InstanceInfo '" + instance + "' could not be resolved");
            return null;
        }
    }

    private int mapPort(InstanceInfo instance) {
        Map metadata = instance.getMetadata();
        if (metadata.containsKey("hazelcast.port")) {
            return Integer.parseInt((String)metadata.get("hazelcast.port"));
        }
        return -1;
    }

    @VisibleForTesting
    void verifyEurekaRegistration() {
        String applicationName = this.applicationInfoManager.getEurekaInstanceConfig().getAppname();
        while (true) {
            block6: {
                try {
                    this.getLogger().info("Waiting for registration with Eureka...");
                    Application application = this.eurekaClient.getApplication(applicationName);
                    if (application != null) {
                        this.getLogger().info("Registered in Eureka");
                        break;
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof Error)) break block6;
                    throw (Error)t;
                }
            }
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException almostIgnore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @VisibleForTesting
    EurekaClient getEurekaClient() {
        return this.eurekaClient;
    }

    private static final class DelegatingInstanceConfig
    implements EurekaInstanceConfig {
        private final EurekaInstanceConfig instanceConfig;
        private final DiscoveryNode localNode;
        private final String uuid;

        private DelegatingInstanceConfig(EurekaInstanceConfig instanceConfig, DiscoveryNode localNode) {
            this.instanceConfig = instanceConfig;
            this.localNode = localNode;
            this.uuid = UuidUtil.newSecureUuidString();
        }

        public String getInstanceId() {
            return this.uuid;
        }

        public String getAppname() {
            return this.instanceConfig.getAppname();
        }

        public String getAppGroupName() {
            return this.instanceConfig.getAppGroupName();
        }

        public boolean isInstanceEnabledOnit() {
            return this.instanceConfig.isInstanceEnabledOnit();
        }

        public int getNonSecurePort() {
            if (null == this.localNode) {
                return this.instanceConfig.getNonSecurePort();
            }
            return this.localNode.getPrivateAddress().getPort();
        }

        public int getSecurePort() {
            return this.instanceConfig.getSecurePort();
        }

        public boolean isNonSecurePortEnabled() {
            return this.instanceConfig.isNonSecurePortEnabled();
        }

        public boolean getSecurePortEnabled() {
            return this.instanceConfig.getSecurePortEnabled();
        }

        public int getLeaseRenewalIntervalInSeconds() {
            return this.instanceConfig.getLeaseRenewalIntervalInSeconds();
        }

        public int getLeaseExpirationDurationInSeconds() {
            return this.instanceConfig.getLeaseExpirationDurationInSeconds();
        }

        public String getVirtualHostName() {
            return this.instanceConfig.getVirtualHostName();
        }

        public String getSecureVirtualHostName() {
            return this.instanceConfig.getSecureVirtualHostName();
        }

        public String getASGName() {
            return this.instanceConfig.getASGName();
        }

        public String getHostName(boolean refresh) {
            return this.instanceConfig.getHostName(refresh);
        }

        public Map<String, String> getMetadataMap() {
            return this.instanceConfig.getMetadataMap();
        }

        public DataCenterInfo getDataCenterInfo() {
            return this.instanceConfig.getDataCenterInfo();
        }

        public String getIpAddress() {
            if (null == this.localNode) {
                return this.instanceConfig.getIpAddress();
            }
            return this.localNode.getPrivateAddress().getHost();
        }

        public String getStatusPageUrlPath() {
            return this.instanceConfig.getStatusPageUrlPath();
        }

        public String getStatusPageUrl() {
            return this.instanceConfig.getStatusPageUrl();
        }

        public String getHomePageUrlPath() {
            return this.instanceConfig.getHomePageUrlPath();
        }

        public String getHomePageUrl() {
            return this.instanceConfig.getHomePageUrl();
        }

        public String getHealthCheckUrlPath() {
            return this.instanceConfig.getHealthCheckUrlPath();
        }

        public String getHealthCheckUrl() {
            return this.instanceConfig.getHealthCheckUrl();
        }

        public String getSecureHealthCheckUrl() {
            return this.instanceConfig.getSecureHealthCheckUrl();
        }

        public String[] getDefaultAddressResolutionOrder() {
            return this.instanceConfig.getDefaultAddressResolutionOrder();
        }

        public String getNamespace() {
            return this.instanceConfig.getNamespace();
        }
    }

    private class EurekaOneAwareConfig
    extends DefaultEurekaClientConfig {
        EurekaOneAwareConfig(String namespace) {
            super(namespace);
        }

        public boolean shouldRegisterWithEureka() {
            return EurekaOneDiscoveryStrategy.this.statusChangeStrategy.shouldRegister();
        }
    }

    static final class EurekaOneDiscoveryStrategyBuilder {
        private EurekaClient eurekaClient;
        private String groupName = "dev";
        private ApplicationInfoManager applicationInfoManager;
        private DiscoveryNode discoveryNode;
        private ILogger logger = new NoLogFactory().getLogger(EurekaOneDiscoveryStrategy.class.getName());
        private Map<String, Comparable> properties = Collections.emptyMap();
        private StatusChangeStrategy changeStrategy;

        EurekaOneDiscoveryStrategyBuilder() {
        }

        EurekaOneDiscoveryStrategyBuilder setEurekaClient(EurekaClient eurekaClient) {
            this.eurekaClient = eurekaClient;
            if (eurekaClient != null) {
                this.applicationInfoManager = eurekaClient.getApplicationInfoManager();
            }
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setApplicationInfoManager(ApplicationInfoManager applicationInfoManager) {
            this.applicationInfoManager = applicationInfoManager;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setDiscoveryNode(DiscoveryNode discoveryNode) {
            this.discoveryNode = discoveryNode;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setILogger(ILogger logger) {
            this.logger = logger;
            return this;
        }

        EurekaOneDiscoveryStrategyBuilder setProperties(Map<String, Comparable> properties) {
            this.properties = properties;
            return this;
        }

        @VisibleForTesting
        EurekaOneDiscoveryStrategyBuilder setStatusChangeStrategy(StatusChangeStrategy statusChangeStrategy) {
            this.changeStrategy = statusChangeStrategy;
            return this;
        }

        EurekaOneDiscoveryStrategy build() {
            if (null == this.changeStrategy) {
                this.changeStrategy = new DefaultUpdater();
            }
            if (null == this.discoveryNode) {
                this.changeStrategy = new NoopUpdater();
            }
            return new EurekaOneDiscoveryStrategy(this);
        }
    }
}

