/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.eureka.one;

import com.google.common.base.Preconditions;
import com.hazelcast.eureka.one.StatusChangeStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import java.util.Map;

class MetadataUpdater
implements StatusChangeStrategy {
    private DiscoveryNode discoveryNode;
    private boolean selfRegistration;
    private String groupName;

    MetadataUpdater(DiscoveryNode discoveryNode, boolean selfRegistration, String groupName) {
        Preconditions.checkNotNull((Object)discoveryNode);
        Preconditions.checkNotNull((Object)groupName);
        this.discoveryNode = discoveryNode;
        this.selfRegistration = selfRegistration;
        this.groupName = groupName;
    }

    @Override
    public void update(ApplicationInfoManager manager, InstanceInfo.InstanceStatus status) {
        Preconditions.checkNotNull((Object)manager);
        Preconditions.checkNotNull((Object)status);
        int port = this.discoveryNode.getPrivateAddress().getPort();
        String host = this.discoveryNode.getPrivateAddress().getHost();
        Map map = manager.getInfo().getMetadata();
        map.put("hazelcast.port", Integer.toString(port));
        map.put("hazelcast.host", host);
        map.put("hazelcast.groupName", this.groupName);
        if (this.shouldRegister()) {
            manager.setInstanceStatus(status);
        }
    }

    @Override
    public boolean shouldRegister() {
        return this.selfRegistration;
    }
}

