/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.gcp.RestClientException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

final class RestClient {
    private static final ILogger LOGGER = Logger.getLogger(RestClient.class);
    private static final int HTTP_OK = 200;
    private final String url;
    private final List<Header> headers = new ArrayList<Header>();
    private String body;

    private RestClient(String url) {
        this.url = url;
    }

    static RestClient create(String url) {
        return new RestClient(url);
    }

    RestClient withHeader(String key, String value) {
        this.headers.add(new Header(key, value));
        return this;
    }

    RestClient withBody(String body) {
        this.body = body;
        return this;
    }

    String get() {
        return this.call("GET");
    }

    String post() {
        return this.call("POST");
    }

    private String call(String method) {
        HttpURLConnection connection = null;
        FilterOutputStream outputStream = null;
        try {
            URL urlToConnect = new URL(this.url);
            connection = (HttpURLConnection)urlToConnect.openConnection();
            connection.setRequestMethod(method);
            for (Header header : this.headers) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            if (this.body != null) {
                byte[] bodyData = this.body.getBytes("UTF-8");
                connection.setDoOutput(true);
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(bodyData.length));
                outputStream = new DataOutputStream(connection.getOutputStream());
                outputStream.write(bodyData);
                ((DataOutputStream)outputStream).flush();
            }
            if (connection.getResponseCode() != 200) {
                throw new RestClientException(String.format("Failure executing: %s at: %s. Message: %s,", method, this.url, RestClient.read(connection.getErrorStream())));
            }
            String string = RestClient.read(connection.getInputStream());
            return string;
        }
        catch (Exception e) {
            throw new RestClientException("Failure in executing REST call", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.finest("Error while closing HTTP output stream", (Throwable)e);
                }
            }
        }
    }

    private static String read(InputStream stream) {
        if (stream == null) {
            return "";
        }
        Scanner scanner = new Scanner(stream, "UTF-8");
        scanner.useDelimiter("\\Z");
        return scanner.next();
    }

    private static final class Header {
        private final String key;
        private final String value;

        private Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private String getKey() {
            return this.key;
        }

        private String getValue() {
            return this.value;
        }
    }
}

