/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Map;
import org.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHazelcastRegion
implements HazelcastRegion {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastRegion.class);
    private final IMap cache;
    private final String regionName;

    protected AbstractHazelcastRegion(String regionName) {
        this.cache = Hazelcast.getMap((String)regionName);
        this.regionName = regionName;
    }

    public final IMap getCache() {
        return this.cache;
    }

    public void destroy() throws CacheException {
        LOG.info("Calling destroy on {}", (Object)this.regionName);
        this.getCache().destroy();
    }

    public long getElementCountInMemory() {
        return this.getCache().size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.getCache().keySet()) {
            MapEntry entry = this.getCache().getMapEntry(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    public int getTimeout() {
        return 245760000;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public Map toMap() {
        return this.getCache();
    }
}

