/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEntry;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HazelcastCache
implements Cache {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastCache.class);
    private final IMap cache;
    private final String regionName;

    public HazelcastCache(String regionName) {
        LOG.info("Creating new HazelcastCache with region name: {}", (Object)regionName);
        this.cache = Hazelcast.getMap((String)regionName);
        this.regionName = regionName;
    }

    public void clear() throws CacheException {
        LOG.info("Calling clear() on {}", (Object)this.regionName);
        this.cache.clear();
    }

    public void destroy() throws CacheException {
        LOG.info("Calling destroy() on {}", (Object)this.regionName);
        this.cache.destroy();
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.cache.keySet()) {
            MapEntry entry = this.cache.getMapEntry(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    public int getTimeout() {
        return 245760000;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void lock(Object key) throws CacheException {
        LOG.debug("Locking region {}", (Object)this.regionName);
        this.cache.lock(key);
    }

    public void unlock(Object key) throws CacheException {
        LOG.debug("Unlocking region {}", (Object)this.regionName);
        this.cache.unlock(key);
    }

    public Object get(Object key) throws CacheException {
        LOG.debug("Getting key {} from region {}", key, (Object)this.regionName);
        return this.cache.get(key);
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        LOG.debug("Putting object into {}", (Object)this.regionName);
        LOG.debug("Using key {}, value {}", key, value);
        this.cache.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        LOG.debug("Removing key {} from region {}", key, (Object)this.regionName);
        this.cache.remove(key);
    }

    public void update(Object key, Object value) throws CacheException {
        LOG.debug("Called update in {}", (Object)this.regionName);
        this.put(key, value);
    }

    public Map toMap() {
        return this.cache;
    }
}

