/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.provider.HazelcastCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public final class HazelcastCacheProvider
implements CacheProvider {
    private static final ILogger LOG = Logger.getLogger((String)HazelcastCacheProvider.class.getName());
    private IHazelcastInstanceLoader instanceLoader = null;
    private HazelcastInstance instance;

    public HazelcastCacheProvider() {
    }

    public HazelcastCacheProvider(HazelcastInstance instance) {
        this.instance = instance;
    }

    public Cache buildCache(String name, Properties properties) throws CacheException {
        return new HazelcastCache(this.instance, name, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Properties props) throws CacheException {
        LOG.log(Level.INFO, "Starting up HazelcastCacheProvider...");
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = HazelcastInstanceFactory.createInstanceLoader(props);
            this.instance = this.instanceLoader.loadInstance();
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public void stop() {
        if (this.instanceLoader != null) {
            LOG.log(Level.INFO, "Shutting down HazelcastCacheProvider...");
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
    }
}

