/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import java.util.Properties;
import org.hibernate.cache.CacheException;

public final class HazelcastInstanceFactory {
    private static final String HZ_CLIENT_LOADER_CLASSNAME = "com.hazelcast.hibernate.instance.HazelcastClientLoader";
    private static final String HZ_INSTANCE_LOADER_CLASSNAME = "com.hazelcast.hibernate.instance.HazelcastInstanceLoader";

    private HazelcastInstanceFactory() {
    }

    public static HazelcastInstance createInstance(Properties props) throws CacheException {
        return HazelcastInstanceFactory.createInstanceLoader(props).loadInstance();
    }

    public static IHazelcastInstanceLoader createInstanceLoader(Properties props) throws CacheException {
        boolean useNativeClient = false;
        if (props != null) {
            useNativeClient = CacheEnvironment.isNativeClient(props);
        }
        IHazelcastInstanceLoader loader = null;
        Class<?> loaderClass = null;
        ClassLoader cl = HazelcastInstanceFactory.class.getClassLoader();
        try {
            loaderClass = useNativeClient ? cl.loadClass(HZ_CLIENT_LOADER_CLASSNAME) : cl.loadClass(HZ_INSTANCE_LOADER_CLASSNAME);
            loader = (IHazelcastInstanceLoader)loaderClass.newInstance();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        loader.configure(props);
        return loader;
    }
}

