/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate3CacheEntrySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate3CacheEntrySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate3 not available, skipping serializer initialization";
    private final Class<?> cacheEntryClass;

    public Hibernate3CacheEntrySerializerHook() {
        Class<?> cacheEntryClass = null;
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            try {
                cacheEntryClass = Class.forName("org.hibernate.cache.entry.CacheEntry");
            }
            catch (Exception e) {
                Logger.getLogger(Hibernate3CacheEntrySerializerHook.class).finest(SKIP_INIT_MSG);
            }
        }
        this.cacheEntryClass = cacheEntryClass;
    }

    public Class getSerializationType() {
        return this.cacheEntryClass;
    }

    public Serializer createSerializer() {
        if (this.cacheEntryClass != null) {
            return new Hibernate3CacheEntrySerializer();
        }
        return null;
    }

    public boolean isOverwritable() {
        return true;
    }
}

