/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;

public class IMapRegionCache
implements RegionCache {
    private final String name;
    private final HazelcastInstance hazelcastInstance;
    private final IMap<Object, Object> map;
    private final Comparator versionComparator;
    private final int lockTimeout;
    private final long tryLockAndGetTimeout;
    private final boolean explicitVersionCheckEnabled;
    private final ILogger logger;
    private static final SoftLock LOCK_SUCCESS = new SoftLock(){};
    private static final SoftLock LOCK_FAILURE = new SoftLock(){};

    public IMapRegionCache(String name, HazelcastInstance hazelcastInstance, Properties props, CacheDataDescription metadata) {
        this.name = name;
        this.hazelcastInstance = hazelcastInstance;
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.map = hazelcastInstance.getMap(this.name);
        this.lockTimeout = CacheEnvironment.getLockTimeoutInMillis(props);
        long maxOperationTimeout = HazelcastTimestamper.getMaxOperationTimeout(hazelcastInstance);
        this.tryLockAndGetTimeout = Math.min(maxOperationTimeout, 500L);
        this.explicitVersionCheckEnabled = CacheEnvironment.isExplicitVersionCheckEnabled(props);
        this.logger = this.createLogger(name, hazelcastInstance);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean put(Object key, Object value, Object currentVersion) {
        return this.update(key, value, currentVersion, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        if (lock == LOCK_FAILURE) {
            this.logger.log(Level.WARNING, "Cache lock could not be acquired!");
            return false;
        }
        if (this.versionComparator != null && currentVersion != null) {
            if (this.explicitVersionCheckEnabled && value instanceof CacheEntry) {
                CacheEntry currentEntry = (CacheEntry)value;
                try {
                    if (!this.map.tryLock(key, this.tryLockAndGetTimeout, TimeUnit.MILLISECONDS)) return false;
                    try {
                        CacheEntry previousEntry = (CacheEntry)this.map.get(key);
                        if (previousEntry == null || this.versionComparator.compare(currentEntry.getVersion(), previousEntry.getVersion()) > 0) {
                            this.map.set(key, value, 0L, TimeUnit.MILLISECONDS);
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        this.map.unlock(key);
                    }
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            if (previousVersion != null) {
                if (this.versionComparator.compare(currentVersion, previousVersion) <= 0) return false;
            }
            this.map.set(key, value, 0L, TimeUnit.MILLISECONDS);
            return true;
        }
        this.map.set(key, value, 0L, TimeUnit.MILLISECONDS);
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.map.remove(key) != null;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        try {
            return this.map.tryLock(key, (long)this.lockTimeout, TimeUnit.MILLISECONDS) ? LOCK_SUCCESS : LOCK_FAILURE;
        }
        catch (InterruptedException e) {
            return LOCK_FAILURE;
        }
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        if (lock == LOCK_SUCCESS) {
            this.map.unlock(key);
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.destroy();
        this.hazelcastInstance.getMap(this.name);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public long getSizeInMemory() {
        long size = 0L;
        for (Object key : this.map.keySet()) {
            EntryView entry = this.map.getEntryView(key);
            if (entry == null) continue;
            size += entry.getCost();
        }
        return size;
    }

    @Override
    public Map asMap() {
        return this.map;
    }

    private ILogger createLogger(String name, HazelcastInstance hazelcastInstance) {
        try {
            return hazelcastInstance.getLoggingService().getLogger(name);
        }
        catch (UnsupportedOperationException e) {
            return Logger.getLogger((String)name);
        }
    }
}

