/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.Invalidation;
import com.hazelcast.hibernate.local.Value;
import com.hazelcast.util.Clock;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.SoftLock;

public class LocalRegionCache
implements RegionCache {
    protected final ITopic<Object> topic;
    protected final MessageListener<Object> messageListener;
    protected final ConcurrentMap<Object, Value> cache;
    protected final Comparator versionComparator;
    protected MapConfig config;
    private static final SoftLock LOCK_SUCCESS = new SoftLock(){

        public String toString() {
            return "Lock::Success";
        }
    };
    private static final SoftLock LOCK_FAILURE = new SoftLock(){

        public String toString() {
            return "Lock::Failure";
        }
    };

    public LocalRegionCache(String name, HazelcastInstance hazelcastInstance, CacheDataDescription metadata) {
        try {
            this.config = hazelcastInstance != null ? hazelcastInstance.getConfig().getMapConfig(name) : null;
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        this.versionComparator = metadata != null && metadata.isVersioned() ? metadata.getVersionComparator() : null;
        this.cache = new ConcurrentHashMap<Object, Value>();
        this.messageListener = this.createMessageListener();
        if (hazelcastInstance != null) {
            this.topic = hazelcastInstance.getTopic(name);
            this.topic.addMessageListener(this.messageListener);
        } else {
            this.topic = null;
        }
    }

    @Override
    public Object get(Object key) {
        Value value = (Value)this.cache.get(key);
        return value != null ? value.getValue() : null;
    }

    @Override
    public boolean put(Object key, Object value, Object currentVersion) {
        Value newValue = new Value(currentVersion, value, null, Clock.currentTimeMillis());
        this.cache.put(key, newValue);
        return true;
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        if (lock == LOCK_FAILURE) {
            return false;
        }
        Value currentValue = (Value)this.cache.get(key);
        if (lock == LOCK_SUCCESS && currentValue != null && currentVersion != null && this.versionComparator.compare(currentVersion, currentValue.getVersion()) < 0) {
            return false;
        }
        if (this.topic != null) {
            this.topic.publish(this.createMessage(key, value, currentVersion));
        }
        this.cache.put(key, new Value(currentVersion, value, lock, Clock.currentTimeMillis()));
        return true;
    }

    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Invalidation(key, currentVersion);
    }

    protected MessageListener<Object> createMessageListener() {
        return new MessageListener<Object>(){

            public void onMessage(Message<Object> message) {
                Invalidation invalidation = (Invalidation)message.getMessageObject();
                if (LocalRegionCache.this.versionComparator != null) {
                    Value value = (Value)LocalRegionCache.this.cache.get(invalidation.getKey());
                    if (value != null) {
                        Object currentVersion = value.getVersion();
                        Object newVersion = invalidation.getVersion();
                        if (LocalRegionCache.this.versionComparator.compare(newVersion, currentVersion) > 0) {
                            LocalRegionCache.this.cache.remove(invalidation.getKey(), value);
                        }
                    }
                } else {
                    LocalRegionCache.this.cache.remove(invalidation.getKey());
                }
            }
        };
    }

    @Override
    public boolean remove(Object key) {
        Value value = (Value)this.cache.remove(key);
        if (value != null) {
            if (this.topic != null) {
                this.topic.publish(this.createMessage(key, null, value.getVersion()));
            }
            return true;
        }
        return false;
    }

    @Override
    public SoftLock tryLock(Object key, Object version) {
        Value value = (Value)this.cache.get(key);
        if (value == null) {
            if (this.cache.putIfAbsent(key, new Value(version, null, LOCK_SUCCESS, Clock.currentTimeMillis())) == null) {
                return LOCK_SUCCESS;
            }
            return LOCK_FAILURE;
        }
        if (version == null || this.versionComparator.compare(version, value.getVersion()) >= 0) {
            if (this.cache.replace(key, value, value.createLockedValue(LOCK_SUCCESS))) {
                return LOCK_SUCCESS;
            }
            return LOCK_FAILURE;
        }
        return LOCK_FAILURE;
    }

    @Override
    public void unlock(Object key, SoftLock lock) {
        SoftLock currentLock;
        Value value = (Value)this.cache.get(key);
        if (value != null && (currentLock = value.getLock()) == lock) {
            this.cache.replace(key, value, value.createUnlockedValue());
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public long getSizeInMemory() {
        return 0L;
    }

    @Override
    public Map asMap() {
        return this.cache;
    }

    void cleanup() {
        long timeToLive;
        int maxSize;
        if (this.config != null) {
            maxSize = this.config.getMaxSizeConfig().getSize();
            timeToLive = (long)this.config.getTimeToLiveSeconds() * 1000L;
        } else {
            maxSize = 100000;
            timeToLive = CacheEnvironment.getDefaultCacheTimeoutInMillis();
        }
        if (maxSize > 0 && maxSize != Integer.MAX_VALUE || timeToLive > 0L) {
            int k;
            Iterator iter = this.cache.entrySet().iterator();
            TreeSet<EvictionEntry> entries = null;
            long now = Clock.currentTimeMillis();
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                Object k2 = e.getKey();
                Value v = (Value)e.getValue();
                if (v.getLock() == LOCK_SUCCESS) continue;
                if (v.getCreationTime() + timeToLive < now) {
                    iter.remove();
                    continue;
                }
                if (maxSize <= 0 || maxSize == Integer.MAX_VALUE) continue;
                if (entries == null) {
                    entries = new TreeSet<EvictionEntry>();
                }
                entries.add(new EvictionEntry(k2, v));
            }
            int diff = this.cache.size() - maxSize;
            int n = k = diff >= 0 ? diff + maxSize * 20 / 100 : 0;
            if (k > 0 && entries != null) {
                int i = 0;
                for (EvictionEntry entry : entries) {
                    if (!this.cache.remove(entry.key, entry.value) || ++i != k) continue;
                    break;
                }
            }
        }
    }

    private class EvictionEntry
    implements Comparable<EvictionEntry> {
        final Object key;
        final Value value;

        private EvictionEntry(Object key, Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(EvictionEntry o) {
            long anotherVal;
            long thisVal = this.value.getCreationTime();
            return thisVal < (anotherVal = o.value.getCreationTime()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvictionEntry that = (EvictionEntry)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }
}

