/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.access.NonStrictReadWriteAccessDelegate;
import com.hazelcast.hibernate.access.ReadOnlyAccessDelegate;
import com.hazelcast.hibernate.access.ReadWriteAccessDelegate;
import com.hazelcast.hibernate.distributed.IMapRegionCache;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.NaturalIdRegionAccessStrategyAdapter;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;

public class HazelcastNaturalIdRegion
extends AbstractTransactionalDataRegion<IMapRegionCache>
implements NaturalIdRegion {
    public HazelcastNaturalIdRegion(HazelcastInstance instance, String regionName, Properties props, CacheDataDescription metadata) {
        super(instance, regionName, props, metadata, new IMapRegionCache(regionName, instance, props, metadata));
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (null == accessType) {
            throw new CacheException("Got null AccessType while attempting to determine a proper NaturalIdRegionAccessStrategy. This can't happen!");
        }
        if (AccessType.READ_ONLY.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new ReadOnlyAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new NonStrictReadWriteAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        if (AccessType.READ_WRITE.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new ReadWriteAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        if (AccessType.TRANSACTIONAL.equals((Object)accessType)) {
            throw new CacheException("Transactional access is not currently supported by Hazelcast.");
        }
        throw new CacheException("Got unknown AccessType \"" + accessType + "\" while attempting to build EntityRegionAccessStrategy.");
    }
}

