/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.AbstractHazelcastCacheRegionFactory;
import com.hazelcast.hibernate.local.CleanupService;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.local.TimestampsRegionCache;
import com.hazelcast.hibernate.region.HazelcastCollectionRegion;
import com.hazelcast.hibernate.region.HazelcastEntityRegion;
import com.hazelcast.hibernate.region.HazelcastTimestampsRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class HazelcastLocalCacheRegionFactory
extends AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    private static final int serialVersionUID = 1;
    private transient CleanupService cleanupService;

    public HazelcastLocalCacheRegionFactory() {
    }

    public HazelcastLocalCacheRegionFactory(HazelcastInstance instance) {
        super(instance);
    }

    public HazelcastLocalCacheRegionFactory(Properties properties) {
        super(properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        HazelcastCollectionRegion<LocalRegionCache> region = new HazelcastCollectionRegion<LocalRegionCache>(this.instance, regionName, properties, metadata, new LocalRegionCache(regionName, this.instance, metadata));
        this.cleanupService.registerCache((LocalRegionCache)region.getCache());
        return region;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        HazelcastEntityRegion<LocalRegionCache> region = new HazelcastEntityRegion<LocalRegionCache>(this.instance, regionName, properties, metadata, new LocalRegionCache(regionName, this.instance, metadata));
        this.cleanupService.registerCache((LocalRegionCache)region.getCache());
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastTimestampsRegion<TimestampsRegionCache>(this.instance, regionName, properties, new TimestampsRegionCache(regionName, this.instance));
    }

    @Override
    public void start(Settings settings, Properties properties) throws CacheException {
        super.start(settings, properties);
        this.cleanupService = new CleanupService(this.instance.getName());
    }

    @Override
    public void stop() {
        this.cleanupService.stop();
        super.stop();
    }
}

