/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.hibernate.access.NonStrictReadWriteAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public class ReadOnlyAccessDelegate<T extends HazelcastRegion>
extends NonStrictReadWriteAccessDelegate<T> {
    public ReadOnlyAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        throw new UnsupportedOperationException("Cannot update an item in a read-only cache: " + this.getHazelcastRegion().getName());
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        throw new UnsupportedOperationException("Attempting to lock an item in a read-only cache region: " + this.getHazelcastRegion().getName());
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        throw new UnsupportedOperationException("Attempting to lock a read-only cache region: " + this.getHazelcastRegion().getName());
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.log.warning("Attempting to unlock an item from a read-only cache region");
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
        this.log.warning("Attempting to unlock a read-only cache region");
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        throw new UnsupportedOperationException("Attempting to update an item in a read-only cache: " + this.getHazelcastRegion().getName());
    }
}

