/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import org.hibernate.cache.spi.access.SoftLock;

public class Value {
    private final Object version;
    private final Object value;
    private final SoftLock lock;
    private final long creationTime;

    public Value(Object version, Object value, long creationTime) {
        this.version = version;
        this.value = value;
        this.creationTime = creationTime;
        this.lock = null;
    }

    public Value(Object version, Object value, SoftLock lock, long creationTime) {
        this.version = version;
        this.value = value;
        this.lock = lock;
        this.creationTime = creationTime;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getVersion() {
        return this.version;
    }

    public SoftLock getLock() {
        return this.lock;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Value createLockedValue(SoftLock lock) {
        return new Value(this.version, this.value, lock, this.creationTime);
    }

    public Value createUnlockedValue() {
        return new Value(this.version, this.value, null, this.creationTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Value value1 = (Value)o;
        if (this.value != null ? !this.value.equals(value1.value) : value1.value != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(value1.version) : value1.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value");
        sb.append("{value=").append(this.value);
        sb.append(", version=").append(this.version);
        sb.append('}');
        return sb.toString();
    }
}

