/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate51CacheEntrySerializer;
import com.hazelcast.hibernate.serialization.Hibernate5CacheEntrySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate5CacheEntrySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate 5 not available, skipping serializer initialization";
    private final Class<?> cacheEntryClass;

    public Hibernate5CacheEntrySerializerHook() {
        Class<?> cacheEntryClass = null;
        try {
            cacheEntryClass = Class.forName("org.hibernate.cache.spi.entry.StandardCacheEntryImpl");
        }
        catch (Exception e) {
            Logger.getLogger(Hibernate5CacheEntrySerializerHook.class).finest(SKIP_INIT_MSG);
        }
        this.cacheEntryClass = cacheEntryClass;
    }

    public Class getSerializationType() {
        return this.cacheEntryClass;
    }

    public Serializer createSerializer() {
        if (this.cacheEntryClass == null) {
            return null;
        }
        try {
            this.cacheEntryClass.getMethod("areLazyPropertiesUnfetched", new Class[0]);
            return new Hibernate5CacheEntrySerializer();
        }
        catch (NoSuchMethodException e) {
            return new Hibernate51CacheEntrySerializer();
        }
    }

    public boolean isOverwritable() {
        return true;
    }
}

