/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.instance.DefaultHazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.local.CleanupService;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.region.HazelcastQueryResultsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;

public abstract class AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    protected HazelcastInstance instance;
    protected CleanupService cleanupService;
    private final ILogger log = Logger.getLogger(this.getClass());
    private IHazelcastInstanceLoader instanceLoader;

    public AbstractHazelcastCacheRegionFactory() {
    }

    public AbstractHazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public AbstractHazelcastCacheRegionFactory(HazelcastInstance instance) {
        this.instance = instance;
    }

    public final QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        HazelcastQueryResultsRegion region = new HazelcastQueryResultsRegion(this.instance, regionName, properties);
        this.cleanupService.registerCache((LocalRegionCache)region.getCache());
        return region;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(SessionFactoryOptions options, Properties properties) throws CacheException {
        this.log.info("Starting up " + this.getClass().getSimpleName());
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = this.resolveInstanceLoader(properties);
            this.instance = this.instanceLoader.loadInstance();
        }
        this.cleanupService = new CleanupService(this.instance.getName(), CacheEnvironment.getCacheCleanup(properties));
    }

    private IHazelcastInstanceLoader resolveInstanceLoader(Properties properties) {
        String factoryName = properties.getProperty("hibernate.cache.hazelcast.factory");
        if (factoryName != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> factory = Class.forName(factoryName, true, cl);
                return ((IHazelcastInstanceFactory)factory.newInstance()).createInstanceLoader(properties);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CacheException("Failed to set up hazelcast instance factory", (Throwable)e);
            }
        }
        return new DefaultHazelcastInstanceFactory().createInstanceLoader(properties);
    }

    public void stop() {
        this.cleanupService.stop();
        if (this.instanceLoader != null) {
            this.log.info("Shutting down " + this.getClass().getSimpleName());
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }
}

