/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public final class NaturalIdCacheKey
implements DataSerializable {
    private Serializable[] naturalIdValues;
    private String entityName;
    private String tenantId;
    private int hashCode;
    private transient ValueHolder<String> toString;

    public NaturalIdCacheKey() {
    }

    public NaturalIdCacheKey(Object[] naturalIdValues, Type[] propertyTypes, int[] naturalIdPropertyIndexes, String entityName, SessionImplementor session) {
        this.naturalIdValues = new Serializable[naturalIdValues.length];
        this.entityName = entityName;
        this.tenantId = session.getTenantIdentifier();
        SessionFactoryImplementor factory = session.getFactory();
        int result = 1;
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        for (int i = 0; i < naturalIdValues.length; ++i) {
            int naturalIdPropertyIndex = naturalIdPropertyIndexes[i];
            Type type = propertyTypes[naturalIdPropertyIndex];
            Object value = naturalIdValues[i];
            result = 31 * result + (value != null ? type.getHashCode(value, factory) : 0);
            this.naturalIdValues[i] = type instanceof EntityType && type.getSemiResolvedType(factory).getReturnedClass().isInstance(value) ? (Serializable)value : type.disassemble(value, session, null);
        }
        this.hashCode = result;
        this.initTransients();
    }

    private void initTransients() {
        this.toString = new ValueHolder(() -> {
            StringBuilder toStringBuilder = new StringBuilder().append(this.entityName).append("##NaturalId[");
            for (int i = 0; i < this.naturalIdValues.length; ++i) {
                toStringBuilder.append(this.naturalIdValues[i]);
                if (i + 1 >= this.naturalIdValues.length) continue;
                toStringBuilder.append(", ");
            }
            toStringBuilder.append("]");
            return toStringBuilder.toString();
        });
    }

    Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.naturalIdValues.length);
        for (Serializable naturalIdValue : this.naturalIdValues) {
            out.writeObject((Object)naturalIdValue);
        }
        out.writeUTF(this.entityName);
        out.writeUTF(this.tenantId);
        out.writeInt(this.hashCode);
    }

    public void readData(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        this.naturalIdValues = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            this.naturalIdValues[i] = (Serializable)in.readObject();
        }
        this.entityName = in.readUTF();
        this.tenantId = in.readUTF();
        this.hashCode = in.readInt();
        this.initTransients();
    }

    public String toString() {
        return (String)this.toString.getValue();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.hashCode != o.hashCode() || !(o instanceof NaturalIdCacheKey)) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return EqualsHelper.equals((Object)this.entityName, (Object)other.entityName) && EqualsHelper.equals((Object)this.tenantId, (Object)other.tenantId) && Arrays.deepEquals(this.naturalIdValues, other.naturalIdValues);
    }
}

