/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.hibernate.access.AccessDelegate;
import com.hazelcast.hibernate.region.HazelcastCacheKeysFactory;
import com.hazelcast.hibernate.region.HazelcastNaturalIdRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public final class NaturalIdRegionAccessStrategyAdapter
implements NaturalIdRegionAccessStrategy {
    private final AccessDelegate<? extends HazelcastNaturalIdRegion> delegate;
    private final CacheKeysFactory cacheKeysFactory = new HazelcastCacheKeysFactory();

    public NaturalIdRegionAccessStrategyAdapter(AccessDelegate<? extends HazelcastNaturalIdRegion> delegate) {
        this.delegate = delegate;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.afterInsert(key, value, null);
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        return this.delegate.afterUpdate(key, value, null, null, lock);
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SharedSessionContractImplementor session) {
        return this.cacheKeysFactory.createNaturalIdKey(naturalIdValues, persister, session);
    }

    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return this.cacheKeysFactory.getNaturalIdValues(cacheKey);
    }

    public NaturalIdRegion getRegion() {
        return this.delegate.getHazelcastRegion();
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.insert(key, value, null);
    }

    public SoftLock lockItem(SharedSessionContractImplementor session, Object key, Object version) throws CacheException {
        return this.delegate.lockItem(key, version);
    }

    public SoftLock lockRegion() throws CacheException {
        return this.delegate.lockRegion();
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public void unlockItem(SharedSessionContractImplementor session, Object key, SoftLock lock) throws CacheException {
        this.delegate.unlockItem(key, lock);
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.delegate.unlockRegion(lock);
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value) throws CacheException {
        return this.delegate.update(key, value, null, null);
    }
}

