/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.PhoneHomeInfo;
import com.hazelcast.hibernate.PhoneHomeService;
import com.hazelcast.hibernate.instance.DefaultHazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.region.HazelcastQueryResultsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;

public abstract class AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    protected HazelcastInstance instance;
    protected final List<LocalRegionCache> localRegionCaches = new ArrayList<LocalRegionCache>();
    private final PhoneHomeService phoneHomeService;
    private final ILogger log = Logger.getLogger(this.getClass());
    private IHazelcastInstanceLoader instanceLoader;

    public AbstractHazelcastCacheRegionFactory() {
        this.phoneHomeService = new PhoneHomeService(this.phoneHomeInfo());
    }

    public AbstractHazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public AbstractHazelcastCacheRegionFactory(PhoneHomeService phoneHomeService) {
        this.phoneHomeService = phoneHomeService;
    }

    public final QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        HazelcastQueryResultsRegion region = new HazelcastQueryResultsRegion(this.instance, regionName, properties);
        this.localRegionCaches.add((LocalRegionCache)region.getCache());
        return region;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(SessionFactoryOptions options, Properties properties) throws CacheException {
        this.log.info("Starting up " + this.getClass().getSimpleName());
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = this.resolveInstanceLoader(properties);
            this.instance = this.instanceLoader.loadInstance();
        }
        this.phoneHomeService.start();
    }

    private IHazelcastInstanceLoader resolveInstanceLoader(Properties properties) {
        String factoryName = properties.getProperty("hibernate.cache.hazelcast.factory");
        if (factoryName != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> factory = Class.forName(factoryName, true, cl);
                return ((IHazelcastInstanceFactory)factory.newInstance()).createInstanceLoader(properties);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CacheException("Failed to set up hazelcast instance factory", (Throwable)e);
            }
        }
        return new DefaultHazelcastInstanceFactory().createInstanceLoader(properties);
    }

    public void stop() {
        this.localRegionCaches.forEach(LocalRegionCache::destroy);
        this.phoneHomeService.shutdown();
        if (this.instanceLoader != null) {
            this.log.info("Shutting down " + this.getClass().getSimpleName());
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    abstract PhoneHomeInfo phoneHomeInfo();
}

