/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.CacheEntryImpl;
import com.hazelcast.hibernate.serialization.Hibernate53CacheEntrySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate5CacheEntrySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate 5 not available, skipping serializer initialization";
    private final Class<?> cacheEntryClass = Hibernate5CacheEntrySerializerHook.tryLoadCacheEntryImpl();

    private static Class<?> tryLoadCacheEntryImpl() {
        try {
            return CacheEntryImpl.class;
        }
        catch (Throwable e) {
            Logger.getLogger(Hibernate5CacheEntrySerializerHook.class).finest(SKIP_INIT_MSG);
            return null;
        }
    }

    public Serializer createSerializer() {
        return this.cacheEntryClass == null ? null : new Hibernate53CacheEntrySerializer();
    }

    public Class<?> getSerializationType() {
        return this.cacheEntryClass;
    }

    public boolean isOverwritable() {
        return true;
    }
}

