/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.FreeHeapBasedCacheEvictor;
import com.hazelcast.hibernate.local.Invalidation;
import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.Value;
import com.hazelcast.hibernate.shaded.caffeine.cache.Cache;
import com.hazelcast.hibernate.shaded.caffeine.cache.Caffeine;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.MessageListener;
import java.time.Duration;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.support.AbstractReadWriteAccess;

public class LocalRegionCache
implements RegionCache {
    private static final int MAX_SIZE = 100000;
    protected final ConcurrentMap<Object, Expirable> cache;
    private final HazelcastInstance hazelcastInstance;
    private final ILogger log = Logger.getLogger(this.getClass());
    private final String name;
    private final RegionFactory regionFactory;
    private final ITopic<Object> topic;
    private final UUID listenerRegistrationId;
    private final Comparator versionComparator;
    private final EvictionConfig evictionConfig;
    private FreeHeapBasedCacheEvictor freeHeapBasedCacheEvictor;
    private MapConfig config;

    protected LocalRegionCache(RegionFactory regionFactory, String name, HazelcastInstance hazelcastInstance, DomainDataRegionConfig regionConfig, boolean withTopic, EvictionConfig evictionConfig, FreeHeapBasedCacheEvictor freeHeapBasedCacheEvictor) {
        this.hazelcastInstance = hazelcastInstance;
        this.name = name;
        this.regionFactory = regionFactory;
        try {
            this.config = hazelcastInstance == null ? null : hazelcastInstance.getConfig().findMapConfig(name);
        }
        catch (UnsupportedOperationException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        if (withTopic && hazelcastInstance != null) {
            this.topic = hazelcastInstance.getTopic(name);
            this.listenerRegistrationId = this.topic.addMessageListener(this.createMessageListener());
        } else {
            this.topic = null;
            this.listenerRegistrationId = null;
        }
        this.versionComparator = this.findVersionComparator(regionConfig).orElse(null);
        this.evictionConfig = evictionConfig == null ? EvictionConfig.create(this.config) : evictionConfig;
        this.cache = this.createCache(freeHeapBasedCacheEvictor, name);
    }

    public static Builder builder() {
        return new Builder();
    }

    private ConcurrentMap<Object, Expirable> createCache(FreeHeapBasedCacheEvictor freeHeapBasedCacheEvictor, String name) {
        Caffeine<Object, Object> caffeineBuilder = Caffeine.newBuilder().expireAfterWrite(this.resolveTTL());
        MaxSizePolicy maxSizePolicy = this.evictionConfig.getMaxSizePolicy();
        Cache caffeineCache = null;
        if (maxSizePolicy == null) {
            maxSizePolicy = MaxSizePolicy.PER_NODE;
        }
        switch (maxSizePolicy) {
            case PER_NODE: {
                caffeineBuilder.maximumSize(this.evictionConfig.getSize());
                break;
            }
            case FREE_HEAP_SIZE: {
                this.freeHeapBasedCacheEvictor = freeHeapBasedCacheEvictor;
                this.assertEvictorPresent(maxSizePolicy);
                this.enableEviction(caffeineBuilder);
                caffeineCache = caffeineBuilder.build();
                long minimalHeapSizeInMB = MemoryUnit.MEGABYTES.toBytes((long)this.evictionConfig.getSize());
                this.freeHeapBasedCacheEvictor.start(name, caffeineCache, minimalHeapSizeInMB);
                break;
            }
            default: {
                throw new IllegalArgumentException(maxSizePolicy + " policy not supported");
            }
        }
        if (caffeineCache == null) {
            caffeineCache = caffeineBuilder.build();
        }
        return caffeineCache.asMap();
    }

    private void enableEviction(Caffeine<Object, Object> caffeineBuilder) {
        caffeineBuilder.maximumSize(Long.MAX_VALUE);
    }

    private void assertEvictorPresent(MaxSizePolicy maxSizePolicy) {
        if (this.freeHeapBasedCacheEvictor == null) {
            throw new IllegalStateException(FreeHeapBasedCacheEvictor.class.getSimpleName() + " is required for " + maxSizePolicy + " policy");
        }
    }

    @Override
    public void afterUpdate(Object key, Object newValue, Object newVersion) {
        this.maybeNotifyTopic(key, newValue, newVersion);
    }

    @Override
    public boolean contains(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public void evictData() {
        this.cache.clear();
        this.maybeNotifyTopic(null, null, null);
    }

    @Override
    public void evictData(Object key) {
        Expirable value = (Expirable)this.cache.remove(key);
        this.maybeNotifyTopic(key, null, value == null ? null : value.getVersion());
    }

    @Override
    public Object get(Object key, long txTimestamp) {
        Expirable value = (Expirable)this.cache.get(key);
        return value == null ? null : value.getValue(txTimestamp);
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public String getName() {
        return this.name;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public long getSizeInMemory() {
        return 0L;
    }

    @Override
    public boolean put(Object key, Object value, long txTimestamp, Object version) {
        Value newValue = new Value(version, this.nextTimestamp(), value);
        this.cache.put(key, newValue);
        return true;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) {
        this.maybeNotifyTopic(key, null, null);
    }

    @Override
    public long nextTimestamp() {
        return this.hazelcastInstance == null ? Clock.currentTimeMillis() : HazelcastTimestamper.nextTimestamp(this.hazelcastInstance);
    }

    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Invalidation(key, currentVersion);
    }

    protected void maybeInvalidate(Object messageObject) {
        Invalidation invalidation = (Invalidation)messageObject;
        Object key = invalidation.getKey();
        if (key == null) {
            this.cache.clear();
        } else if (this.versionComparator == null) {
            this.cache.remove(key);
        } else {
            Expirable value = (Expirable)this.cache.get(key);
            if (value != null) {
                this.maybeInvalidateVersionedEntity(key, value, invalidation.getVersion());
            }
        }
    }

    @Override
    public void destroy() {
        if (this.freeHeapBasedCacheEvictor != null) {
            this.freeHeapBasedCacheEvictor.stop(this.name);
        }
        if (this.topic != null && this.listenerRegistrationId != null) {
            this.topic.removeMessageListener(this.listenerRegistrationId);
        }
    }

    void maybeNotifyTopic(Object key, Object value, Object version) {
        if (this.topic != null) {
            this.topic.publish(this.createMessage(key, value, version));
        }
    }

    private MessageListener<Object> createMessageListener() {
        return message -> {
            if (message.getPublishingMember() == null || this.hazelcastInstance == null || this.isClient() || !message.getPublishingMember().equals(this.hazelcastInstance.getCluster().getLocalMember())) {
                this.maybeInvalidate(message.getMessageObject());
            }
        };
    }

    private boolean isClient() {
        return this.hazelcastInstance instanceof HazelcastClientProxy;
    }

    private Optional<Comparator<?>> findVersionComparator(DomainDataRegionConfig regionConfig) {
        if (regionConfig == null) {
            return Optional.empty();
        }
        for (EntityDataCachingConfig entityConfig : regionConfig.getEntityCaching()) {
            if (!entityConfig.isVersioned()) continue;
            try {
                return Optional.ofNullable((Comparator)entityConfig.getVersionComparatorAccess().get());
            }
            catch (Throwable throwable) {
                this.log.warning("Unable to get version comparator", throwable);
                return Optional.empty();
            }
        }
        return regionConfig.getCollectionCaching().stream().filter(DomainDataCachingConfig::isVersioned).findFirst().map(CollectionDataCachingConfig::getOwnerVersionComparator);
    }

    private void maybeInvalidateVersionedEntity(Object key, Expirable value, Object newVersion) {
        if (newVersion == null) {
            this.cache.remove(key);
        } else {
            AbstractReadWriteAccess.Lockable cachedItem = (AbstractReadWriteAccess.Lockable)value.getValue();
            if (cachedItem.isWriteable(this.nextTimestamp(), newVersion, this.versionComparator)) {
                this.cache.remove(key, value);
            }
        }
    }

    private Duration resolveTTL() {
        return Math.max(this.evictionConfig.getTimeToLive().toMillis(), 0L) == 0L ? Duration.ofMillis(Integer.MAX_VALUE) : this.evictionConfig.getTimeToLive();
    }

    public static interface EvictionConfig {
        public Duration getTimeToLive();

        @Deprecated
        default public int getMaxSize() {
            return this.getSize();
        }

        public int getSize();

        public MaxSizePolicy getMaxSizePolicy();

        public static EvictionConfig create(MapConfig mapConfig) {
            return new DefaultEvictionConfig(mapConfig);
        }

        public static class DefaultEvictionConfig
        implements EvictionConfig {
            private final MapConfig mapConfig;

            DefaultEvictionConfig(MapConfig mapConfig) {
                this.mapConfig = mapConfig;
            }

            @Override
            public Duration getTimeToLive() {
                return this.mapConfig == null ? Duration.ofMillis(CacheEnvironment.getDefaultCacheTimeoutInMillis()) : Duration.ofSeconds(this.mapConfig.getTimeToLiveSeconds());
            }

            @Override
            public int getSize() {
                return this.mapConfig == null ? 100000 : this.mapConfig.getEvictionConfig().getSize();
            }

            @Override
            public MaxSizePolicy getMaxSizePolicy() {
                return this.mapConfig == null ? MapConfig.DEFAULT_MAX_SIZE_POLICY : this.mapConfig.getEvictionConfig().getMaxSizePolicy();
            }
        }
    }

    public static final class Builder {
        private RegionFactory regionFactory;
        private String name;
        private HazelcastInstance hazelcastInstance;
        private DomainDataRegionConfig regionConfig;
        private boolean withTopic;
        private EvictionConfig evictionConfig;
        private FreeHeapBasedCacheEvictor freeHeapBasedCacheEvictor;

        public LocalRegionCache build() {
            return new LocalRegionCache(this.regionFactory, this.name, this.hazelcastInstance, this.regionConfig, this.withTopic, this.evictionConfig, this.freeHeapBasedCacheEvictor);
        }

        public Builder withRegionFactory(RegionFactory regionFactory) {
            this.regionFactory = regionFactory;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
            return this;
        }

        public Builder withRegionConfig(DomainDataRegionConfig regionConfig) {
            this.regionConfig = regionConfig;
            return this;
        }

        public Builder withTopic(boolean withTopic) {
            this.withTopic = withTopic;
            return this;
        }

        public Builder withEvictionConfig(EvictionConfig evictionConfig) {
            this.evictionConfig = evictionConfig;
            return this;
        }

        public Builder withFreeHeapBasedCacheEvictor(FreeHeapBasedCacheEvictor freeHeapBasedCacheEvictor) {
            this.freeHeapBasedCacheEvictor = freeHeapBasedCacheEvictor;
            return this;
        }
    }
}

