/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.internal.util.Preconditions;

public class ClientFlakeIdGeneratorConfig {
    public static final int DEFAULT_PREFETCH_COUNT = 100;
    public static final long DEFAULT_PREFETCH_VALIDITY_MILLIS = 600000L;
    public static final int DEFAULT_BITS_NODE_ID = 16;
    public static final int MAXIMUM_PREFETCH_COUNT = 100000;
    private String name;
    private int prefetchCount = 100;
    private long prefetchValidityMillis = 600000L;

    private ClientFlakeIdGeneratorConfig() {
    }

    public ClientFlakeIdGeneratorConfig(String name) {
        this.name = name;
    }

    public ClientFlakeIdGeneratorConfig(ClientFlakeIdGeneratorConfig other) {
        this.name = other.name;
        this.prefetchCount = other.prefetchCount;
        this.prefetchValidityMillis = other.prefetchValidityMillis;
    }

    public String getName() {
        return this.name;
    }

    public ClientFlakeIdGeneratorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public ClientFlakeIdGeneratorConfig setPrefetchCount(int prefetchCount) {
        Preconditions.checkTrue(prefetchCount > 0 && prefetchCount <= 100000, "prefetch-count must be 1..100000, not " + prefetchCount);
        this.prefetchCount = prefetchCount;
        return this;
    }

    public long getPrefetchValidityMillis() {
        return this.prefetchValidityMillis;
    }

    public ClientFlakeIdGeneratorConfig setPrefetchValidityMillis(long prefetchValidityMs) {
        this.prefetchValidityMillis = prefetchValidityMs;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientFlakeIdGeneratorConfig that = (ClientFlakeIdGeneratorConfig)o;
        if (this.prefetchCount != that.prefetchCount) {
            return false;
        }
        if (this.prefetchValidityMillis != that.prefetchValidityMillis) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.prefetchCount;
        result = 31 * result + (int)(this.prefetchValidityMillis ^ this.prefetchValidityMillis >>> 32);
        return result;
    }

    public String toString() {
        return "ClientFlakeIdGeneratorConfig{name='" + this.name + "', prefetchCount=" + this.prefetchCount + ", prefetchValidityMillis=" + this.prefetchValidityMillis + "}";
    }
}

