/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClusterRoutingConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.impl.connection.tcp.RoutingMode;
import com.hazelcast.config.AutoDetectionConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class ClientNetworkConfig {
    private static final int CONNECTION_TIMEOUT = 5000;
    private final List<String> addressList;
    private ClusterRoutingConfig clusterRoutingConfig = new ClusterRoutingConfig();
    private boolean redoOperation;
    private boolean smartRouting = true;
    private int connectionTimeout = 5000;
    private SocketInterceptorConfig socketInterceptorConfig = new SocketInterceptorConfig();
    private SocketOptions socketOptions = new SocketOptions();
    private SSLConfig sslConfig;
    private Collection<String> outboundPortDefinitions;
    private Collection<Integer> outboundPorts;
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();
    private ClientIcmpPingConfig clientIcmpPingConfig = new ClientIcmpPingConfig();
    private AutoDetectionConfig autoDetectionConfig = new AutoDetectionConfig();

    public ClientNetworkConfig() {
        this.addressList = new ArrayList<String>();
    }

    public ClientNetworkConfig(ClientNetworkConfig networkConfig) {
        this.addressList = new ArrayList<String>(networkConfig.addressList);
        this.clusterRoutingConfig = new ClusterRoutingConfig(networkConfig.getClusterRoutingConfig());
        this.redoOperation = networkConfig.redoOperation;
        this.connectionTimeout = networkConfig.connectionTimeout;
        this.socketInterceptorConfig = new SocketInterceptorConfig(networkConfig.socketInterceptorConfig);
        this.socketOptions = new SocketOptions(networkConfig.socketOptions);
        this.sslConfig = networkConfig.sslConfig == null ? null : new SSLConfig(networkConfig.sslConfig);
        this.discoveryConfig = new DiscoveryConfig(networkConfig.discoveryConfig);
        this.outboundPortDefinitions = networkConfig.outboundPortDefinitions == null ? null : new HashSet<String>(networkConfig.outboundPortDefinitions);
        this.outboundPorts = networkConfig.outboundPorts == null ? null : new HashSet<Integer>(networkConfig.outboundPorts);
        this.clientIcmpPingConfig = new ClientIcmpPingConfig(networkConfig.clientIcmpPingConfig);
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public ClientNetworkConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryConfig");
        return this;
    }

    public ClusterRoutingConfig getClusterRoutingConfig() {
        return this.clusterRoutingConfig;
    }

    public ClientNetworkConfig setClusterRoutingConfig(ClusterRoutingConfig clusterRoutingConfig) {
        this.clusterRoutingConfig = Preconditions.checkNotNull(clusterRoutingConfig, "clusterRoutingConfig cannot be null");
        return this;
    }

    @Deprecated(since="5.5")
    public ClientNetworkConfig setSmartRouting(boolean smartRouting) {
        this.clusterRoutingConfig.setRoutingMode(smartRouting ? RoutingMode.ALL_MEMBERS : RoutingMode.SINGLE_MEMBER);
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public ClientNetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = Preconditions.isNotNull(socketInterceptorConfig, "socketInterceptorConfig");
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientNetworkConfig setConnectionTimeout(int connectionTimeoutInMillis) {
        if (connectionTimeoutInMillis < 0) {
            throw new IllegalArgumentException("connectionTimeout cannot be negative");
        }
        this.connectionTimeout = connectionTimeoutInMillis;
        return this;
    }

    public ClientNetworkConfig addAddress(String ... addresses) {
        Preconditions.isNotNull(addresses, "addresses");
        for (String address : addresses) {
            Preconditions.isNotNull(address, "address");
            Preconditions.checkHasText(address.trim(), "member must contain text");
        }
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public ClientNetworkConfig setAddresses(List<String> addresses) {
        Preconditions.isNotNull(addresses, "addresses");
        this.addressList.clear();
        this.addressList.addAll(addresses);
        return this;
    }

    public List<String> getAddresses() {
        return this.addressList;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public AutoDetectionConfig getAutoDetectionConfig() {
        return this.autoDetectionConfig;
    }

    public boolean isAutoDetectionEnabled() {
        return this.autoDetectionConfig.isEnabled() && this.addressList.isEmpty();
    }

    public ClientNetworkConfig setAutoDetectionConfig(AutoDetectionConfig autoDetectionConfig) {
        this.autoDetectionConfig = Preconditions.isNotNull(autoDetectionConfig, "autoDetectionConfig");
        return this;
    }

    @Deprecated(since="5.5")
    public boolean isSmartRouting() {
        return this.clusterRoutingConfig.getRoutingMode() == RoutingMode.ALL_MEMBERS;
    }

    public ClientNetworkConfig setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public ClientNetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public ClientNetworkConfig setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public Collection<String> getOutboundPortDefinitions() {
        return this.outboundPortDefinitions;
    }

    public Collection<Integer> getOutboundPorts() {
        return this.outboundPorts;
    }

    public ClientNetworkConfig setOutboundPortDefinitions(Collection<String> outboundPortDefinitions) {
        this.outboundPortDefinitions = outboundPortDefinitions;
        return this;
    }

    public ClientNetworkConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        this.outboundPorts = outboundPorts;
        return this;
    }

    public ClientNetworkConfig addOutboundPort(int port) {
        if (this.outboundPorts == null) {
            this.outboundPorts = new HashSet<Integer>();
        }
        this.outboundPorts.add(port);
        return this;
    }

    public ClientNetworkConfig addOutboundPortDefinition(String portDef) {
        if (this.outboundPortDefinitions == null) {
            this.outboundPortDefinitions = new HashSet<String>();
        }
        this.outboundPortDefinitions.add(portDef);
        return this;
    }

    public ClientIcmpPingConfig getClientIcmpPingConfig() {
        return this.clientIcmpPingConfig;
    }

    public ClientNetworkConfig setClientIcmpPingConfig(ClientIcmpPingConfig clientIcmpPingConfig) {
        this.clientIcmpPingConfig = clientIcmpPingConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientNetworkConfig that = (ClientNetworkConfig)o;
        if (this.redoOperation != that.redoOperation) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (!this.addressList.equals(that.addressList)) {
            return false;
        }
        if (!this.socketInterceptorConfig.equals(that.socketInterceptorConfig)) {
            return false;
        }
        if (!this.socketOptions.equals(that.socketOptions)) {
            return false;
        }
        if (!Objects.equals(this.sslConfig, that.sslConfig)) {
            return false;
        }
        if (!Objects.equals(this.outboundPortDefinitions, that.outboundPortDefinitions)) {
            return false;
        }
        if (!Objects.equals(this.outboundPorts, that.outboundPorts)) {
            return false;
        }
        if (!this.clusterRoutingConfig.equals(that.clusterRoutingConfig)) {
            return false;
        }
        return this.clientIcmpPingConfig.equals(that.clientIcmpPingConfig);
    }

    public int hashCode() {
        int result = this.addressList.hashCode();
        result = 31 * result + (this.smartRouting ? 1 : 0);
        result = 31 * result + (this.redoOperation ? 1 : 0);
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.socketInterceptorConfig.hashCode();
        result = 31 * result + this.socketOptions.hashCode();
        result = 31 * result + (this.sslConfig != null ? this.sslConfig.hashCode() : 0);
        result = 31 * result + this.discoveryConfig.hashCode();
        result = 31 * result + (this.outboundPortDefinitions != null ? this.outboundPortDefinitions.hashCode() : 0);
        result = 31 * result + (this.outboundPorts != null ? this.outboundPorts.hashCode() : 0);
        result = 31 * result + this.clientIcmpPingConfig.hashCode();
        result = 31 * result + this.clusterRoutingConfig.hashCode();
        return result;
    }

    public String toString() {
        return "ClientNetworkConfig{addressList=" + this.addressList + ", smartRouting=" + this.smartRouting + ", redoOperation=" + this.redoOperation + ", connectionTimeout=" + this.connectionTimeout + ", socketInterceptorConfig=" + this.socketInterceptorConfig + ", socketOptions=" + this.socketOptions + ", sslConfig=" + this.sslConfig + ", discoveryConfig=" + this.discoveryConfig + ", outboundPortDefinitions=" + this.outboundPortDefinitions + ", outboundPorts=" + this.outboundPorts + ", clientIcmpPingConfig=" + this.clientIcmpPingConfig + ", clusterRoutingConfig=" + this.clusterRoutingConfig + "}";
    }
}

