/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.Client;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.impl.listener.ClientCPGroupViewService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.TerminatedLifecycleService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.topic.ITopic;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class HazelcastClientProxy
implements HazelcastInstance,
SerializationServiceSupport {
    public volatile HazelcastClientInstanceImpl client;

    public HazelcastClientProxy(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    @Override
    public TaskScheduler getTaskScheduler() {
        return this.client.getTaskScheduler();
    }

    @Override
    public ClientInvocationService getInvocationService() {
        return this.client.getInvocationService();
    }

    @Override
    public ClientListenerService getListenerService() {
        return this.client.getListenerService();
    }

    @Override
    public ClientClusterService getClientClusterService() {
        return this.client.getClientClusterService();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.client.getName();
    }

    @Override
    @Nonnull
    public String getInstanceName() {
        return this.getClient().getInstanceName();
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.getClient().getList(name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.getClient().getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.getClient().getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        return this.getClient().getRingbuffer(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        return this.getClient().getReliableTopic(name);
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        return this.client.getScheduledExecutorService(name);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        return this.client.getFlakeIdGenerator(name);
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    @Override
    public LifecycleService getLifecycleService() {
        HazelcastClientInstanceImpl hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        return this.client.getExecutorService(name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        return this.client.getPNCounter(name);
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    @Override
    public ClientCPGroupViewService getCPGroupViewService() {
        return this.client.getCPGroupViewService();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.client.getCPSubsystem();
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        return this.getClient().getQueue(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        return this.getClient().getTopic(name);
    }

    @Override
    public SerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    protected HazelcastClientInstanceImpl getClient() {
        HazelcastClientInstanceImpl c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastClientNotActiveException();
        }
        return c;
    }

    public String toString() {
        HazelcastClientInstanceImpl hazelcastInstance = this.client;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastClientInstance {NOT ACTIVE}";
    }
}

