/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.JsonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class KeyValuePairGenerator {
    public static final String GROUPS = "groups";
    public static final String VERSION = "version";

    private KeyValuePairGenerator() {
    }

    public static Map<CPGroupId, UUID> parseJsonForCPMembership(String jsonArray) {
        if (jsonArray.equals("[]")) {
            return Collections.emptyMap();
        }
        JsonArray baseArray = Json.parse(jsonArray).asArray();
        HashMap<CPGroupId, UUID> leadersMap = new HashMap<CPGroupId, UUID>(baseArray.size());
        for (JsonValue entry : baseArray) {
            JsonObject baseObject = entry.asObject();
            JsonValue raftIdValue = baseObject.get("raftId");
            JsonValue leaderUUIDValue = baseObject.get("leaderUUID");
            if (raftIdValue == null || leaderUUIDValue == null) {
                throw new IllegalArgumentException("Invalid Json string received for CP group view: " + jsonArray);
            }
            JsonObject raftIdObject = raftIdValue.asObject();
            RaftGroupId raftGroupId = new RaftGroupId(raftIdObject.get("name").asString(), raftIdObject.get("seed").asLong(), raftIdObject.get("id").asLong());
            UUID leaderUUID = UUID.fromString(leaderUUIDValue.asString());
            leadersMap.put(raftGroupId, leaderUUID);
        }
        return leadersMap;
    }

    public static MemberGroupsAndVersionHolder parseJsonForMemberGroups(String memberGroupsJsonString) {
        JsonValue value = Json.parse(memberGroupsJsonString);
        JsonObject root = value.asObject();
        JsonValue versionValue = root.get(VERSION);
        int version = versionValue.asInt();
        HashSet<Collection<UUID>> allMemberGroups = new HashSet<Collection<UUID>>();
        JsonArray groups = JsonUtil.getArray(root, GROUPS);
        List<JsonValue> uuidArrays = groups.values();
        for (JsonValue uuidArrayValue : uuidArrays) {
            JsonArray uuidArray = uuidArrayValue.asArray();
            HashSet<UUID> memberGroup = new HashSet<UUID>();
            for (JsonValue uuidValue : uuidArray.values()) {
                UUID uuid = UUID.fromString(uuidValue.asString());
                memberGroup.add(uuid);
            }
            allMemberGroups.add(memberGroup);
        }
        return new MemberGroupsAndVersionHolder(allMemberGroups, version);
    }

    public record MemberGroupsAndVersionHolder(Collection<Collection<UUID>> allMemberGroups, int version) {
    }
}

