/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RaftGroupIdCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.cp.internal.RaftGroupId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class CPSessionCreateSessionCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1F0100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1F0101;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_SESSION_ID_FIELD_OFFSET = 13;
    private static final int RESPONSE_TTL_MILLIS_FIELD_OFFSET = 21;
    private static final int RESPONSE_HEARTBEAT_MILLIS_FIELD_OFFSET = 29;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 37;

    private CPSessionCreateSessionCodec() {
    }

    public static ClientMessage encodeRequest(RaftGroupId groupId, String endpointName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("CPSession.CreateSession");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1F0100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        StringCodec.encode(clientMessage, endpointName);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator.next();
        request.groupId = RaftGroupIdCodec.decode(iterator);
        request.endpointName = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long sessionId, long ttlMillis, long heartbeatMillis) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1F0101);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 13, sessionId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 21, ttlMillis);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 29, heartbeatMillis);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.sessionId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 13);
        response.ttlMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 21);
        response.heartbeatMillis = FixedSizeTypesCodec.decodeLong(initialFrame.content, 29);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public RaftGroupId groupId;
        public String endpointName;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long sessionId;
        public long ttlMillis;
        public long heartbeatMillis;
    }
}

