/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPMemberCodec;
import com.hazelcast.client.impl.protocol.codec.RaftGroupIdCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public final class CPSubsystemAddGroupAvailabilityListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x220300;
    public static final int RESPONSE_MESSAGE_TYPE = 2228993;
    private static final int REQUEST_LOCAL_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_GROUP_AVAILABILITY_EVENT_IS_SHUTDOWN_FIELD_OFFSET = 16;
    private static final int EVENT_GROUP_AVAILABILITY_EVENT_INITIAL_FRAME_SIZE = 17;
    private static final int EVENT_GROUP_AVAILABILITY_EVENT_MESSAGE_TYPE = 0x220302;

    private CPSubsystemAddGroupAvailabilityListenerCodec() {
    }

    public static ClientMessage encodeRequest(boolean local) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("CPSubsystem.AddGroupAvailabilityListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x220300);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, local);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static boolean decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2228993);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeGroupAvailabilityEventEvent(RaftGroupId groupId, Collection<CPMember> members, Collection<CPMember> unavailableMembers, boolean isShutdown) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x220302);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, isShutdown);
        clientMessage.add(initialFrame);
        RaftGroupIdCodec.encode(clientMessage, groupId);
        ListMultiFrameCodec.encode(clientMessage, members, CPMemberCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, unavailableMembers, CPMemberCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 0x220302) {
                ClientMessage.Frame initialFrame = iterator.next();
                boolean isIsShutdownExists = false;
                boolean isShutdown = false;
                if (initialFrame.content.length >= 17) {
                    isShutdown = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
                    isIsShutdownExists = true;
                }
                RaftGroupId groupId = RaftGroupIdCodec.decode(iterator);
                List<CPMember> members = ListMultiFrameCodec.decode(iterator, CPMemberCodec::decode);
                List<CPMember> unavailableMembers = ListMultiFrameCodec.decode(iterator, CPMemberCodec::decode);
                this.handleGroupAvailabilityEventEvent(groupId, members, unavailableMembers, isIsShutdownExists, isShutdown);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleGroupAvailabilityEventEvent(RaftGroupId var1, Collection<CPMember> var2, Collection<CPMember> var3, boolean var4, boolean var5);
    }
}

