/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RaftGroupInfoCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListUUIDUUIDCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.cp.internal.RaftGroupInfo;
import com.hazelcast.logging.Logger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ClientAddCPGroupViewListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 5888;
    public static final int RESPONSE_MESSAGE_TYPE = 5889;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;
    private static final int EVENT_GROUPS_VIEW_VERSION_FIELD_OFFSET = 16;
    private static final int EVENT_GROUPS_VIEW_INITIAL_FRAME_SIZE = 24;
    private static final int EVENT_GROUPS_VIEW_MESSAGE_TYPE = 5890;

    private ClientAddCPGroupViewListenerCodec() {
    }

    public static ClientMessage encodeRequest() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.AddCPGroupViewListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 5888);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 5889);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ClientMessage encodeGroupsViewEvent(long version, Collection<RaftGroupInfo> groupsInfo, Collection<Map.Entry<UUID, UUID>> cpToApUuids) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 5890);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, version);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, groupsInfo, RaftGroupInfoCodec::encode);
        EntryListUUIDUUIDCodec.encode(clientMessage, cpToApUuids);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 5890) {
                ClientMessage.Frame initialFrame = iterator.next();
                long version = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
                List<RaftGroupInfo> groupsInfo = ListMultiFrameCodec.decode(iterator, RaftGroupInfoCodec::decode);
                List<Map.Entry<UUID, UUID>> cpToApUuids = EntryListUUIDUUIDCodec.decode(iterator);
                this.handleGroupsViewEvent(version, groupsInfo, cpToApUuids);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleGroupsViewEvent(long var1, Collection<RaftGroupInfo> var3, Collection<Map.Entry<UUID, UUID>> var4);
    }
}

