/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.cp.internal.RaftGroupId;

public final class RaftGroupIdCodec {
    private static final int SEED_FIELD_OFFSET = 0;
    private static final int ID_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 16;

    private RaftGroupIdCodec() {
    }

    public static void encode(ClientMessage clientMessage, RaftGroupId raftGroupId) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, raftGroupId.getSeed());
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 8, raftGroupId.getId());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, raftGroupId.getName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static RaftGroupId decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        long seed = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        long id = FixedSizeTypesCodec.decodeLong(initialFrame.content, 8);
        String name = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new RaftGroupId(name, seed, id);
    }
}

