/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPMemberCodec;
import com.hazelcast.client.impl.protocol.codec.RaftGroupIdCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftGroupInfo;
import java.util.List;

public final class RaftGroupInfoCodec {
    private RaftGroupInfoCodec() {
    }

    public static void encode(ClientMessage clientMessage, RaftGroupInfo raftGroupInfo) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        RaftGroupIdCodec.encode(clientMessage, raftGroupInfo.getGroupId());
        CPMemberCodec.encode(clientMessage, raftGroupInfo.getLeader());
        ListMultiFrameCodec.encode(clientMessage, raftGroupInfo.getFollowers(), CPMemberCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static RaftGroupInfo decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        RaftGroupId groupId = RaftGroupIdCodec.decode(iterator);
        CPMemberInfo leader = CPMemberCodec.decode(iterator);
        List<CPMember> followers = ListMultiFrameCodec.decode(iterator, CPMemberCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new RaftGroupInfo(groupId, leader, followers);
    }
}

