/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.holder.AnchorDataListHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.List;
import java.util.Map;

public final class AnchorDataListHolderCodec {
    private AnchorDataListHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, AnchorDataListHolder anchorDataListHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ListIntegerCodec.encode(clientMessage, anchorDataListHolder.getAnchorPageList());
        EntryListCodec.encode(clientMessage, anchorDataListHolder.getAnchorDataList(), DataCodec::encode, DataCodec::encodeNullable);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static AnchorDataListHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        List<Integer> anchorPageList = ListIntegerCodec.decode(iterator);
        List<Map.Entry<Data, Data>> anchorDataList = EntryListCodec.decode(iterator, DataCodec::decode, DataCodec::decodeNullable);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new AnchorDataListHolder(anchorPageList, anchorDataList);
    }

    public static Data decodeNullable(ClientMessage.ForwardFrameIterator iterator) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : DataCodec.decode(iterator);
    }
}

