/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.util;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.spi.impl.sequence.CallIdSequenceWithoutBackpressure;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ClientMessageSplitter {
    private static final CallIdSequenceWithoutBackpressure FRAGMENT_ID_SEQUENCE = new CallIdSequenceWithoutBackpressure();

    private ClientMessageSplitter() {
    }

    public static List<ClientMessage> getFragments(int maxFrameSize, ClientMessage clientMessage) {
        if (clientMessage.getFrameLength() <= maxFrameSize) {
            return Collections.singletonList(clientMessage);
        }
        long fragmentId = FRAGMENT_ID_SEQUENCE.next();
        LinkedList<ClientMessage> fragments = new LinkedList<ClientMessage>();
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ReadState state = ReadState.BEGINNING;
        int length = 0;
        ClientMessage fragment = null;
        while (iterator.hasNext()) {
            ClientMessage.Frame frame = iterator.peekNext();
            int frameSize = frame.getSize();
            length += frameSize;
            if (frameSize > maxFrameSize) {
                iterator.next();
                if (state == ReadState.MIDDLE) {
                    fragments.add(fragment);
                }
                fragment = ClientMessageSplitter.createFragment(fragmentId);
                fragment.add(frame.copy());
                fragments.add(fragment);
                state = ReadState.BEGINNING;
                length = 0;
                continue;
            }
            if (length <= maxFrameSize) {
                iterator.next();
                if (state == ReadState.BEGINNING) {
                    fragment = ClientMessageSplitter.createFragment(fragmentId);
                }
                fragment.add(frame.copy());
                state = ReadState.MIDDLE;
                continue;
            }
            fragments.add(fragment);
            state = ReadState.BEGINNING;
            length = 0;
        }
        if (state == ReadState.MIDDLE) {
            fragments.add(fragment);
        }
        ((ClientMessage)fragments.getFirst()).getStartFrame().flags |= 0x8000;
        ((ClientMessage)fragments.getLast()).getStartFrame().flags |= 0x4000;
        return fragments;
    }

    private static ClientMessage createFragment(long fragmentId) {
        ClientMessage fragment = ClientMessage.createForEncode();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[8]);
        Bits.writeLongL(frame.content, 0, fragmentId);
        fragment.add(frame);
        return fragment;
    }

    private static enum ReadState {
        BEGINNING,
        MIDDLE;

    }
}

