/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.internal.util.Clock;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ClientClusterProxy
implements Cluster {
    private final ClientClusterService clusterService;

    public ClientClusterProxy(ClientClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Override
    @Nonnull
    public UUID addMembershipListener(@Nonnull MembershipListener listener) {
        return this.clusterService.addMembershipListener(listener);
    }

    @Override
    public boolean removeMembershipListener(@Nonnull UUID registrationId) {
        return this.clusterService.removeMembershipListener(registrationId);
    }

    @Override
    @Nonnull
    public Set<Member> getMembers() {
        Collection<Member> members = this.clusterService.getMemberList();
        return new LinkedHashSet<Member>(members);
    }

    @Override
    @Nonnull
    public Member getLocalMember() {
        throw new UnsupportedOperationException("Client has no local member!");
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis();
    }
}

